// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SerializedBinaryFuseFilter's original definition in the XDR file is:
 *
 * <pre>
 * struct SerializedBinaryFuseFilter
 * {
 *     BinaryFuseFilterType type;
 *
 *     // Seed used to hash input to filter
 *     ShortHashSeed inputHashSeed;
 *
 *     // Seed used for internal filter hash operations
 *     ShortHashSeed filterSeed;
 *     uint32 segmentLength;
 *     uint32 segementLengthMask;
 *     uint32 segmentCount;
 *     uint32 segmentCountLength;
 *     uint32 fingerprintLength; // Length in terms of element count, not bytes
 *
 *     // Array of uint8_t, uint16_t, or uint32_t depending on filter type
 *     opaque fingerprints&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SerializedBinaryFuseFilter implements XdrElement {
  private BinaryFuseFilterType type;
  private ShortHashSeed inputHashSeed;
  private ShortHashSeed filterSeed;
  private Uint32 segmentLength;
  private Uint32 segementLengthMask;
  private Uint32 segmentCount;
  private Uint32 segmentCountLength;
  private Uint32 fingerprintLength;
  private byte[] fingerprints;

  public void encode(XdrDataOutputStream stream) throws IOException {
    type.encode(stream);
    inputHashSeed.encode(stream);
    filterSeed.encode(stream);
    segmentLength.encode(stream);
    segementLengthMask.encode(stream);
    segmentCount.encode(stream);
    segmentCountLength.encode(stream);
    fingerprintLength.encode(stream);
    int fingerprintsSize = fingerprints.length;
    stream.writeInt(fingerprintsSize);
    stream.write(getFingerprints(), 0, fingerprintsSize);
  }

  public static SerializedBinaryFuseFilter decode(XdrDataInputStream stream) throws IOException {
    SerializedBinaryFuseFilter decodedSerializedBinaryFuseFilter = new SerializedBinaryFuseFilter();
    decodedSerializedBinaryFuseFilter.type = BinaryFuseFilterType.decode(stream);
    decodedSerializedBinaryFuseFilter.inputHashSeed = ShortHashSeed.decode(stream);
    decodedSerializedBinaryFuseFilter.filterSeed = ShortHashSeed.decode(stream);
    decodedSerializedBinaryFuseFilter.segmentLength = Uint32.decode(stream);
    decodedSerializedBinaryFuseFilter.segementLengthMask = Uint32.decode(stream);
    decodedSerializedBinaryFuseFilter.segmentCount = Uint32.decode(stream);
    decodedSerializedBinaryFuseFilter.segmentCountLength = Uint32.decode(stream);
    decodedSerializedBinaryFuseFilter.fingerprintLength = Uint32.decode(stream);
    int fingerprintsSize = stream.readInt();
    decodedSerializedBinaryFuseFilter.fingerprints = new byte[fingerprintsSize];
    stream.read(decodedSerializedBinaryFuseFilter.fingerprints, 0, fingerprintsSize);
    return decodedSerializedBinaryFuseFilter;
  }

  public static SerializedBinaryFuseFilter fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SerializedBinaryFuseFilter fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
