/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import lombok.NonNull;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.Network;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.AssetCodeLengthInvalidException;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.ContractIDPreimageType;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;

public abstract class Asset
implements Comparable<Asset> {
    Asset() {
    }

    public static Asset create(String canonicalForm) {
        if (canonicalForm.equals("native")) {
            return Asset.create(canonicalForm, null, null);
        }
        String[] parts = canonicalForm.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid asset " + canonicalForm);
        }
        return Asset.create(null, parts[0], parts[1]);
    }

    public static Asset create(String type, String code, String issuer) {
        if (type == null) {
            return Asset.createNonNativeAsset(code, issuer);
        }
        if (type.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(code, issuer);
    }

    public static Asset fromXdr(org.stellar.sdk.xdr.Asset xdr) {
        switch (xdr.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return new AssetTypeNative();
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                String assetCode4 = Util.paddedByteArrayToString(xdr.getAlphaNum4().getAssetCode().getAssetCode4());
                String accountId = StrKey.encodeEd25519PublicKey(xdr.getAlphaNum4().getIssuer());
                return new AssetTypeCreditAlphaNum4(assetCode4, accountId);
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                String assetCode12 = Util.paddedByteArrayToString(xdr.getAlphaNum12().getAssetCode().getAssetCode12());
                String accountId = StrKey.encodeEd25519PublicKey(xdr.getAlphaNum12().getIssuer());
                return new AssetTypeCreditAlphaNum12(assetCode12, accountId);
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract AssetType getType();

    public abstract org.stellar.sdk.xdr.Asset toXdr();

    public abstract boolean equals(Object var1);

    @Override
    public abstract int compareTo(@NonNull Asset var1);

    public static Asset createNonNativeAsset(@NonNull String code, @NonNull String issuer) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        if (!code.isEmpty() && code.length() <= 4) {
            return new AssetTypeCreditAlphaNum4(code, issuer);
        }
        if (code.length() >= 5 && code.length() <= 12) {
            return new AssetTypeCreditAlphaNum12(code, issuer);
        }
        throw new AssetCodeLengthInvalidException();
    }

    public static Asset createNativeAsset() {
        return new AssetTypeNative();
    }

    public String getContractId(Network network) {
        HashIDPreimage preimage = HashIDPreimage.builder().discriminant(EnvelopeType.ENVELOPE_TYPE_CONTRACT_ID).contractID(HashIDPreimage.HashIDPreimageContractID.builder().networkID(new Hash(network.getNetworkId())).contractIDPreimage(ContractIDPreimage.builder().discriminant(ContractIDPreimageType.CONTRACT_ID_PREIMAGE_FROM_ASSET).fromAsset(this.toXdr()).build()).build()).build();
        byte[] rawContractId = null;
        try {
            rawContractId = Util.hash(preimage.toXdrByteArray());
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        return StrKey.encodeContract(rawContractId);
    }
}

