/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.federation;

import com.google.gson.reflect.TypeToken;
import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.exception.ConnectionErrorException;
import org.stellar.sdk.federation.FederationResponse;
import org.stellar.sdk.federation.exception.FederationServerInvalidException;
import org.stellar.sdk.federation.exception.MalformedAddressException;
import org.stellar.sdk.federation.exception.NoFederationServerException;
import org.stellar.sdk.federation.exception.NotFoundException;
import org.stellar.sdk.federation.exception.StellarTomlNotFoundInvalidException;
import org.stellar.sdk.requests.ResponseHandler;

public class Federation {
    private final OkHttpClient httpClient;

    public Federation(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Federation() {
        this.httpClient = Federation.createHttpClient();
    }

    public FederationResponse resolveAddress(String address) {
        String[] tokens = address.split("\\*");
        if (tokens.length != 2) {
            throw new MalformedAddressException("address is malformed, it should be in the format `bob*stellar.org`");
        }
        String domain = tokens[1];
        QueryType queryType = QueryType.NAME;
        return this.resolve(address, domain, queryType);
    }

    public FederationResponse resolveAccountId(String accountId, String domain) {
        return this.resolve(accountId, domain, QueryType.ID);
    }

    private FederationResponse resolve(String q, String domain, QueryType queryType) {
        HttpUrl federationServerUri = this.getFederationServerUri(domain);
        HttpUrl.Builder uriBuilder = federationServerUri.newBuilder();
        uriBuilder.setQueryParameter("type", queryType.getValue());
        uriBuilder.setQueryParameter("q", q);
        HttpUrl uri = uriBuilder.build();
        TypeToken<FederationResponse> type = new TypeToken<FederationResponse>(){};
        ResponseHandler<FederationResponse> responseHandler = new ResponseHandler<FederationResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            if (response.code() == 404) {
                throw new NotFoundException();
            }
            FederationResponse federationResponse = responseHandler.handleResponse(response);
            if (response != null) {
                response.close();
            }
            return federationResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConnectionErrorException(e);
            }
        }
    }

    private HttpUrl getFederationServerUri(@NonNull String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        String uriBuilder = "https://" + domain + "/.well-known/stellar.toml";
        HttpUrl stellarTomlUri = HttpUrl.parse(uriBuilder);
        assert (stellarTomlUri != null);
        Request request = new Request.Builder().get().url(stellarTomlUri).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            if (response.code() >= 300) {
                throw new StellarTomlNotFoundInvalidException(response.code());
            }
            assert (response.body() != null);
            Toml stellarToml = new Toml().read(response.body().string());
            String federationServer = stellarToml.getString("FEDERATION_SERVER");
            if (federationServer == null || federationServer.isEmpty()) {
                throw new NoFederationServerException();
            }
            HttpUrl federationServerUrl = HttpUrl.parse(federationServer);
            if (federationServerUrl == null || !federationServerUrl.isHttps()) {
                throw new FederationServerInvalidException();
            }
            HttpUrl httpUrl = federationServerUrl;
            if (response != null) {
                response.close();
            }
            return httpUrl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConnectionErrorException(e);
            }
        }
    }

    private static OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(false).build();
    }

    private static enum QueryType {
        NAME("name"),
        ID("id");

        private final String value;

        private QueryType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

