/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum BinaryFuseFilterType implements XdrElement
{
    BINARY_FUSE_FILTER_8_BIT(0),
    BINARY_FUSE_FILTER_16_BIT(1),
    BINARY_FUSE_FILTER_32_BIT(2);

    private final int value;

    private BinaryFuseFilterType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BinaryFuseFilterType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return BINARY_FUSE_FILTER_8_BIT;
            }
            case 1: {
                return BINARY_FUSE_FILTER_16_BIT;
            }
            case 2: {
                return BINARY_FUSE_FILTER_32_BIT;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static BinaryFuseFilterType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BinaryFuseFilterType.fromXdrByteArray(bytes);
    }

    public static BinaryFuseFilterType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BinaryFuseFilterType.decode(xdrDataInputStream);
    }
}

