/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Curve25519Secret
implements XdrElement {
    private byte[] key;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int keySize = this.key.length;
        stream.write(this.getKey(), 0, keySize);
    }

    public static Curve25519Secret decode(XdrDataInputStream stream) throws IOException {
        Curve25519Secret decodedCurve25519Secret = new Curve25519Secret();
        int keySize = 32;
        decodedCurve25519Secret.key = new byte[keySize];
        stream.read(decodedCurve25519Secret.key, 0, keySize);
        return decodedCurve25519Secret;
    }

    public static Curve25519Secret fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Curve25519Secret.fromXdrByteArray(bytes);
    }

    public static Curve25519Secret fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Curve25519Secret.decode(xdrDataInputStream);
    }

    @Generated
    public static Curve25519SecretBuilder builder() {
        return new Curve25519SecretBuilder();
    }

    @Generated
    public Curve25519SecretBuilder toBuilder() {
        return new Curve25519SecretBuilder().key(this.key);
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public void setKey(byte[] key) {
        this.key = key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Curve25519Secret)) {
            return false;
        }
        Curve25519Secret other = (Curve25519Secret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Curve25519Secret;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    @Generated
    public String toString() {
        return "Curve25519Secret(key=" + Arrays.toString(this.getKey()) + ")";
    }

    @Generated
    public Curve25519Secret() {
    }

    @Generated
    public Curve25519Secret(byte[] key) {
        this.key = key;
    }

    @Generated
    public static class Curve25519SecretBuilder {
        @Generated
        private byte[] key;

        @Generated
        Curve25519SecretBuilder() {
        }

        @Generated
        public Curve25519SecretBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public Curve25519Secret build() {
            return new Curve25519Secret(this.key);
        }

        @Generated
        public String toString() {
            return "Curve25519Secret.Curve25519SecretBuilder(key=" + Arrays.toString(this.key) + ")";
        }
    }
}

