/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.HostFunction;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InvokeHostFunctionOp
implements XdrElement {
    private HostFunction hostFunction;
    private SorobanAuthorizationEntry[] auth;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.hostFunction.encode(stream);
        int authSize = this.getAuth().length;
        stream.writeInt(authSize);
        for (int i = 0; i < authSize; ++i) {
            this.auth[i].encode(stream);
        }
    }

    public static InvokeHostFunctionOp decode(XdrDataInputStream stream) throws IOException {
        InvokeHostFunctionOp decodedInvokeHostFunctionOp = new InvokeHostFunctionOp();
        decodedInvokeHostFunctionOp.hostFunction = HostFunction.decode(stream);
        int authSize = stream.readInt();
        decodedInvokeHostFunctionOp.auth = new SorobanAuthorizationEntry[authSize];
        for (int i = 0; i < authSize; ++i) {
            decodedInvokeHostFunctionOp.auth[i] = SorobanAuthorizationEntry.decode(stream);
        }
        return decodedInvokeHostFunctionOp;
    }

    public static InvokeHostFunctionOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InvokeHostFunctionOp.fromXdrByteArray(bytes);
    }

    public static InvokeHostFunctionOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InvokeHostFunctionOp.decode(xdrDataInputStream);
    }

    @Generated
    public static InvokeHostFunctionOpBuilder builder() {
        return new InvokeHostFunctionOpBuilder();
    }

    @Generated
    public InvokeHostFunctionOpBuilder toBuilder() {
        return new InvokeHostFunctionOpBuilder().hostFunction(this.hostFunction).auth(this.auth);
    }

    @Generated
    public HostFunction getHostFunction() {
        return this.hostFunction;
    }

    @Generated
    public SorobanAuthorizationEntry[] getAuth() {
        return this.auth;
    }

    @Generated
    public void setHostFunction(HostFunction hostFunction) {
        this.hostFunction = hostFunction;
    }

    @Generated
    public void setAuth(SorobanAuthorizationEntry[] auth) {
        this.auth = auth;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvokeHostFunctionOp)) {
            return false;
        }
        InvokeHostFunctionOp other = (InvokeHostFunctionOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HostFunction this$hostFunction = this.getHostFunction();
        HostFunction other$hostFunction = other.getHostFunction();
        if (this$hostFunction == null ? other$hostFunction != null : !((Object)this$hostFunction).equals(other$hostFunction)) {
            return false;
        }
        return Arrays.deepEquals(this.getAuth(), other.getAuth());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvokeHostFunctionOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HostFunction $hostFunction = this.getHostFunction();
        result = result * 59 + ($hostFunction == null ? 43 : ((Object)$hostFunction).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAuth());
        return result;
    }

    @Generated
    public String toString() {
        return "InvokeHostFunctionOp(hostFunction=" + this.getHostFunction() + ", auth=" + Arrays.deepToString(this.getAuth()) + ")";
    }

    @Generated
    public InvokeHostFunctionOp() {
    }

    @Generated
    public InvokeHostFunctionOp(HostFunction hostFunction, SorobanAuthorizationEntry[] auth) {
        this.hostFunction = hostFunction;
        this.auth = auth;
    }

    @Generated
    public static class InvokeHostFunctionOpBuilder {
        @Generated
        private HostFunction hostFunction;
        @Generated
        private SorobanAuthorizationEntry[] auth;

        @Generated
        InvokeHostFunctionOpBuilder() {
        }

        @Generated
        public InvokeHostFunctionOpBuilder hostFunction(HostFunction hostFunction) {
            this.hostFunction = hostFunction;
            return this;
        }

        @Generated
        public InvokeHostFunctionOpBuilder auth(SorobanAuthorizationEntry[] auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public InvokeHostFunctionOp build() {
            return new InvokeHostFunctionOp(this.hostFunction, this.auth);
        }

        @Generated
        public String toString() {
            return "InvokeHostFunctionOp.InvokeHostFunctionOpBuilder(hostFunction=" + this.hostFunction + ", auth=" + Arrays.deepToString(this.auth) + ")";
        }
    }
}

