/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCAddressType implements XdrElement
{
    SC_ADDRESS_TYPE_ACCOUNT(0),
    SC_ADDRESS_TYPE_CONTRACT(1);

    private final int value;

    private SCAddressType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SCAddressType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SC_ADDRESS_TYPE_ACCOUNT;
            }
            case 1: {
                return SC_ADDRESS_TYPE_CONTRACT;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SCAddressType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCAddressType.fromXdrByteArray(bytes);
    }

    public static SCAddressType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCAddressType.decode(xdrDataInputStream);
    }
}

