/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractExecutable;
import org.stellar.sdk.xdr.SCMap;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCContractInstance
implements XdrElement {
    private ContractExecutable executable;
    private SCMap storage;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.executable.encode(stream);
        if (this.storage != null) {
            stream.writeInt(1);
            this.storage.encode(stream);
        } else {
            stream.writeInt(0);
        }
    }

    public static SCContractInstance decode(XdrDataInputStream stream) throws IOException {
        SCContractInstance decodedSCContractInstance = new SCContractInstance();
        decodedSCContractInstance.executable = ContractExecutable.decode(stream);
        int storagePresent = stream.readInt();
        if (storagePresent != 0) {
            decodedSCContractInstance.storage = SCMap.decode(stream);
        }
        return decodedSCContractInstance;
    }

    public static SCContractInstance fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCContractInstance.fromXdrByteArray(bytes);
    }

    public static SCContractInstance fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCContractInstance.decode(xdrDataInputStream);
    }

    @Generated
    public static SCContractInstanceBuilder builder() {
        return new SCContractInstanceBuilder();
    }

    @Generated
    public SCContractInstanceBuilder toBuilder() {
        return new SCContractInstanceBuilder().executable(this.executable).storage(this.storage);
    }

    @Generated
    public ContractExecutable getExecutable() {
        return this.executable;
    }

    @Generated
    public SCMap getStorage() {
        return this.storage;
    }

    @Generated
    public void setExecutable(ContractExecutable executable) {
        this.executable = executable;
    }

    @Generated
    public void setStorage(SCMap storage) {
        this.storage = storage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCContractInstance)) {
            return false;
        }
        SCContractInstance other = (SCContractInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractExecutable this$executable = this.getExecutable();
        ContractExecutable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        SCMap this$storage = this.getStorage();
        SCMap other$storage = other.getStorage();
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCContractInstance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractExecutable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        SCMap $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCContractInstance(executable=" + this.getExecutable() + ", storage=" + this.getStorage() + ")";
    }

    @Generated
    public SCContractInstance() {
    }

    @Generated
    public SCContractInstance(ContractExecutable executable, SCMap storage) {
        this.executable = executable;
        this.storage = storage;
    }

    @Generated
    public static class SCContractInstanceBuilder {
        @Generated
        private ContractExecutable executable;
        @Generated
        private SCMap storage;

        @Generated
        SCContractInstanceBuilder() {
        }

        @Generated
        public SCContractInstanceBuilder executable(ContractExecutable executable) {
            this.executable = executable;
            return this;
        }

        @Generated
        public SCContractInstanceBuilder storage(SCMap storage) {
            this.storage = storage;
            return this;
        }

        @Generated
        public SCContractInstance build() {
            return new SCContractInstance(this.executable, this.storage);
        }

        @Generated
        public String toString() {
            return "SCContractInstance.SCContractInstanceBuilder(executable=" + this.executable + ", storage=" + this.storage + ")";
        }
    }
}

