/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecFunctionInputV0;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecFunctionV0
implements XdrElement {
    private XdrString doc;
    private SCSymbol name;
    private SCSpecFunctionInputV0[] inputs;
    private SCSpecTypeDef[] outputs;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.doc.encode(stream);
        this.name.encode(stream);
        int inputsSize = this.getInputs().length;
        stream.writeInt(inputsSize);
        for (int i = 0; i < inputsSize; ++i) {
            this.inputs[i].encode(stream);
        }
        int outputsSize = this.getOutputs().length;
        stream.writeInt(outputsSize);
        for (int i = 0; i < outputsSize; ++i) {
            this.outputs[i].encode(stream);
        }
    }

    public static SCSpecFunctionV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecFunctionV0 decodedSCSpecFunctionV0 = new SCSpecFunctionV0();
        decodedSCSpecFunctionV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecFunctionV0.name = SCSymbol.decode(stream);
        int inputsSize = stream.readInt();
        decodedSCSpecFunctionV0.inputs = new SCSpecFunctionInputV0[inputsSize];
        for (int i = 0; i < inputsSize; ++i) {
            decodedSCSpecFunctionV0.inputs[i] = SCSpecFunctionInputV0.decode(stream);
        }
        int outputsSize = stream.readInt();
        decodedSCSpecFunctionV0.outputs = new SCSpecTypeDef[outputsSize];
        for (int i = 0; i < outputsSize; ++i) {
            decodedSCSpecFunctionV0.outputs[i] = SCSpecTypeDef.decode(stream);
        }
        return decodedSCSpecFunctionV0;
    }

    public static SCSpecFunctionV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecFunctionV0.fromXdrByteArray(bytes);
    }

    public static SCSpecFunctionV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecFunctionV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecFunctionV0Builder builder() {
        return new SCSpecFunctionV0Builder();
    }

    @Generated
    public SCSpecFunctionV0Builder toBuilder() {
        return new SCSpecFunctionV0Builder().doc(this.doc).name(this.name).inputs(this.inputs).outputs(this.outputs);
    }

    @Generated
    public XdrString getDoc() {
        return this.doc;
    }

    @Generated
    public SCSymbol getName() {
        return this.name;
    }

    @Generated
    public SCSpecFunctionInputV0[] getInputs() {
        return this.inputs;
    }

    @Generated
    public SCSpecTypeDef[] getOutputs() {
        return this.outputs;
    }

    @Generated
    public void setDoc(XdrString doc) {
        this.doc = doc;
    }

    @Generated
    public void setName(SCSymbol name) {
        this.name = name;
    }

    @Generated
    public void setInputs(SCSpecFunctionInputV0[] inputs) {
        this.inputs = inputs;
    }

    @Generated
    public void setOutputs(SCSpecTypeDef[] outputs) {
        this.outputs = outputs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecFunctionV0)) {
            return false;
        }
        SCSpecFunctionV0 other = (SCSpecFunctionV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XdrString this$doc = this.getDoc();
        XdrString other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        SCSymbol this$name = this.getName();
        SCSymbol other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
            return false;
        }
        return Arrays.deepEquals(this.getOutputs(), other.getOutputs());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecFunctionV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XdrString $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        SCSymbol $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInputs());
        result = result * 59 + Arrays.deepHashCode(this.getOutputs());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecFunctionV0(doc=" + this.getDoc() + ", name=" + this.getName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ", outputs=" + Arrays.deepToString(this.getOutputs()) + ")";
    }

    @Generated
    public SCSpecFunctionV0() {
    }

    @Generated
    public SCSpecFunctionV0(XdrString doc, SCSymbol name, SCSpecFunctionInputV0[] inputs, SCSpecTypeDef[] outputs) {
        this.doc = doc;
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @Generated
    public static class SCSpecFunctionV0Builder {
        @Generated
        private XdrString doc;
        @Generated
        private SCSymbol name;
        @Generated
        private SCSpecFunctionInputV0[] inputs;
        @Generated
        private SCSpecTypeDef[] outputs;

        @Generated
        SCSpecFunctionV0Builder() {
        }

        @Generated
        public SCSpecFunctionV0Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        @Generated
        public SCSpecFunctionV0Builder name(SCSymbol name) {
            this.name = name;
            return this;
        }

        @Generated
        public SCSpecFunctionV0Builder inputs(SCSpecFunctionInputV0[] inputs) {
            this.inputs = inputs;
            return this;
        }

        @Generated
        public SCSpecFunctionV0Builder outputs(SCSpecTypeDef[] outputs) {
            this.outputs = outputs;
            return this;
        }

        @Generated
        public SCSpecFunctionV0 build() {
            return new SCSpecFunctionV0(this.doc, this.name, this.inputs, this.outputs);
        }

        @Generated
        public String toString() {
            return "SCSpecFunctionV0.SCSpecFunctionV0Builder(doc=" + this.doc + ", name=" + this.name + ", inputs=" + Arrays.deepToString(this.inputs) + ", outputs=" + Arrays.deepToString(this.outputs) + ")";
        }
    }
}

