/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.Int128Parts;
import org.stellar.sdk.xdr.Int256Parts;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCBytes;
import org.stellar.sdk.xdr.SCContractInstance;
import org.stellar.sdk.xdr.SCError;
import org.stellar.sdk.xdr.SCMap;
import org.stellar.sdk.xdr.SCNonceKey;
import org.stellar.sdk.xdr.SCString;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.SCValType;
import org.stellar.sdk.xdr.SCVec;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.UInt128Parts;
import org.stellar.sdk.xdr.UInt256Parts;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCVal
implements XdrElement {
    private SCValType discriminant;
    private Boolean b;
    private SCError error;
    private Uint32 u32;
    private Int32 i32;
    private Uint64 u64;
    private Int64 i64;
    private TimePoint timepoint;
    private Duration duration;
    private UInt128Parts u128;
    private Int128Parts i128;
    private UInt256Parts u256;
    private Int256Parts i256;
    private SCBytes bytes;
    private SCString str;
    private SCSymbol sym;
    private SCVec vec;
    private SCMap map;
    private SCAddress address;
    private SCNonceKey nonce_key;
    private SCContractInstance instance;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SCV_BOOL: {
                stream.writeInt(this.b != false ? 1 : 0);
                break;
            }
            case SCV_VOID: {
                break;
            }
            case SCV_ERROR: {
                this.error.encode(stream);
                break;
            }
            case SCV_U32: {
                this.u32.encode(stream);
                break;
            }
            case SCV_I32: {
                this.i32.encode(stream);
                break;
            }
            case SCV_U64: {
                this.u64.encode(stream);
                break;
            }
            case SCV_I64: {
                this.i64.encode(stream);
                break;
            }
            case SCV_TIMEPOINT: {
                this.timepoint.encode(stream);
                break;
            }
            case SCV_DURATION: {
                this.duration.encode(stream);
                break;
            }
            case SCV_U128: {
                this.u128.encode(stream);
                break;
            }
            case SCV_I128: {
                this.i128.encode(stream);
                break;
            }
            case SCV_U256: {
                this.u256.encode(stream);
                break;
            }
            case SCV_I256: {
                this.i256.encode(stream);
                break;
            }
            case SCV_BYTES: {
                this.bytes.encode(stream);
                break;
            }
            case SCV_STRING: {
                this.str.encode(stream);
                break;
            }
            case SCV_SYMBOL: {
                this.sym.encode(stream);
                break;
            }
            case SCV_VEC: {
                if (this.vec != null) {
                    stream.writeInt(1);
                    this.vec.encode(stream);
                    break;
                }
                stream.writeInt(0);
                break;
            }
            case SCV_MAP: {
                if (this.map != null) {
                    stream.writeInt(1);
                    this.map.encode(stream);
                    break;
                }
                stream.writeInt(0);
                break;
            }
            case SCV_ADDRESS: {
                this.address.encode(stream);
                break;
            }
            case SCV_LEDGER_KEY_CONTRACT_INSTANCE: {
                break;
            }
            case SCV_LEDGER_KEY_NONCE: {
                this.nonce_key.encode(stream);
                break;
            }
            case SCV_CONTRACT_INSTANCE: {
                this.instance.encode(stream);
            }
        }
    }

    public static SCVal decode(XdrDataInputStream stream) throws IOException {
        SCVal decodedSCVal = new SCVal();
        SCValType discriminant = SCValType.decode(stream);
        decodedSCVal.setDiscriminant(discriminant);
        switch (decodedSCVal.getDiscriminant()) {
            case SCV_BOOL: {
                decodedSCVal.b = stream.readInt() == 1;
                break;
            }
            case SCV_VOID: {
                break;
            }
            case SCV_ERROR: {
                decodedSCVal.error = SCError.decode(stream);
                break;
            }
            case SCV_U32: {
                decodedSCVal.u32 = Uint32.decode(stream);
                break;
            }
            case SCV_I32: {
                decodedSCVal.i32 = Int32.decode(stream);
                break;
            }
            case SCV_U64: {
                decodedSCVal.u64 = Uint64.decode(stream);
                break;
            }
            case SCV_I64: {
                decodedSCVal.i64 = Int64.decode(stream);
                break;
            }
            case SCV_TIMEPOINT: {
                decodedSCVal.timepoint = TimePoint.decode(stream);
                break;
            }
            case SCV_DURATION: {
                decodedSCVal.duration = Duration.decode(stream);
                break;
            }
            case SCV_U128: {
                decodedSCVal.u128 = UInt128Parts.decode(stream);
                break;
            }
            case SCV_I128: {
                decodedSCVal.i128 = Int128Parts.decode(stream);
                break;
            }
            case SCV_U256: {
                decodedSCVal.u256 = UInt256Parts.decode(stream);
                break;
            }
            case SCV_I256: {
                decodedSCVal.i256 = Int256Parts.decode(stream);
                break;
            }
            case SCV_BYTES: {
                decodedSCVal.bytes = SCBytes.decode(stream);
                break;
            }
            case SCV_STRING: {
                decodedSCVal.str = SCString.decode(stream);
                break;
            }
            case SCV_SYMBOL: {
                decodedSCVal.sym = SCSymbol.decode(stream);
                break;
            }
            case SCV_VEC: {
                int vecPresent = stream.readInt();
                if (vecPresent == 0) break;
                decodedSCVal.vec = SCVec.decode(stream);
                break;
            }
            case SCV_MAP: {
                int mapPresent = stream.readInt();
                if (mapPresent == 0) break;
                decodedSCVal.map = SCMap.decode(stream);
                break;
            }
            case SCV_ADDRESS: {
                decodedSCVal.address = SCAddress.decode(stream);
                break;
            }
            case SCV_LEDGER_KEY_CONTRACT_INSTANCE: {
                break;
            }
            case SCV_LEDGER_KEY_NONCE: {
                decodedSCVal.nonce_key = SCNonceKey.decode(stream);
                break;
            }
            case SCV_CONTRACT_INSTANCE: {
                decodedSCVal.instance = SCContractInstance.decode(stream);
            }
        }
        return decodedSCVal;
    }

    public static SCVal fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCVal.fromXdrByteArray(bytes);
    }

    public static SCVal fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCVal.decode(xdrDataInputStream);
    }

    @Generated
    public static SCValBuilder builder() {
        return new SCValBuilder();
    }

    @Generated
    public SCValBuilder toBuilder() {
        return new SCValBuilder().discriminant(this.discriminant).b(this.b).error(this.error).u32(this.u32).i32(this.i32).u64(this.u64).i64(this.i64).timepoint(this.timepoint).duration(this.duration).u128(this.u128).i128(this.i128).u256(this.u256).i256(this.i256).bytes(this.bytes).str(this.str).sym(this.sym).vec(this.vec).map(this.map).address(this.address).nonce_key(this.nonce_key).instance(this.instance);
    }

    @Generated
    public SCValType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Boolean getB() {
        return this.b;
    }

    @Generated
    public SCError getError() {
        return this.error;
    }

    @Generated
    public Uint32 getU32() {
        return this.u32;
    }

    @Generated
    public Int32 getI32() {
        return this.i32;
    }

    @Generated
    public Uint64 getU64() {
        return this.u64;
    }

    @Generated
    public Int64 getI64() {
        return this.i64;
    }

    @Generated
    public TimePoint getTimepoint() {
        return this.timepoint;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public UInt128Parts getU128() {
        return this.u128;
    }

    @Generated
    public Int128Parts getI128() {
        return this.i128;
    }

    @Generated
    public UInt256Parts getU256() {
        return this.u256;
    }

    @Generated
    public Int256Parts getI256() {
        return this.i256;
    }

    @Generated
    public SCBytes getBytes() {
        return this.bytes;
    }

    @Generated
    public SCString getStr() {
        return this.str;
    }

    @Generated
    public SCSymbol getSym() {
        return this.sym;
    }

    @Generated
    public SCVec getVec() {
        return this.vec;
    }

    @Generated
    public SCMap getMap() {
        return this.map;
    }

    @Generated
    public SCAddress getAddress() {
        return this.address;
    }

    @Generated
    public SCNonceKey getNonce_key() {
        return this.nonce_key;
    }

    @Generated
    public SCContractInstance getInstance() {
        return this.instance;
    }

    @Generated
    public void setDiscriminant(SCValType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setB(Boolean b) {
        this.b = b;
    }

    @Generated
    public void setError(SCError error) {
        this.error = error;
    }

    @Generated
    public void setU32(Uint32 u32) {
        this.u32 = u32;
    }

    @Generated
    public void setI32(Int32 i32) {
        this.i32 = i32;
    }

    @Generated
    public void setU64(Uint64 u64) {
        this.u64 = u64;
    }

    @Generated
    public void setI64(Int64 i64) {
        this.i64 = i64;
    }

    @Generated
    public void setTimepoint(TimePoint timepoint) {
        this.timepoint = timepoint;
    }

    @Generated
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Generated
    public void setU128(UInt128Parts u128) {
        this.u128 = u128;
    }

    @Generated
    public void setI128(Int128Parts i128) {
        this.i128 = i128;
    }

    @Generated
    public void setU256(UInt256Parts u256) {
        this.u256 = u256;
    }

    @Generated
    public void setI256(Int256Parts i256) {
        this.i256 = i256;
    }

    @Generated
    public void setBytes(SCBytes bytes) {
        this.bytes = bytes;
    }

    @Generated
    public void setStr(SCString str) {
        this.str = str;
    }

    @Generated
    public void setSym(SCSymbol sym) {
        this.sym = sym;
    }

    @Generated
    public void setVec(SCVec vec) {
        this.vec = vec;
    }

    @Generated
    public void setMap(SCMap map) {
        this.map = map;
    }

    @Generated
    public void setAddress(SCAddress address) {
        this.address = address;
    }

    @Generated
    public void setNonce_key(SCNonceKey nonce_key) {
        this.nonce_key = nonce_key;
    }

    @Generated
    public void setInstance(SCContractInstance instance) {
        this.instance = instance;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCVal)) {
            return false;
        }
        SCVal other = (SCVal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$b = this.getB();
        Boolean other$b = other.getB();
        if (this$b == null ? other$b != null : !((Object)this$b).equals(other$b)) {
            return false;
        }
        SCValType this$discriminant = this.getDiscriminant();
        SCValType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        SCError this$error = this.getError();
        SCError other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        Uint32 this$u32 = this.getU32();
        Uint32 other$u32 = other.getU32();
        if (this$u32 == null ? other$u32 != null : !((Object)this$u32).equals(other$u32)) {
            return false;
        }
        Int32 this$i32 = this.getI32();
        Int32 other$i32 = other.getI32();
        if (this$i32 == null ? other$i32 != null : !((Object)this$i32).equals(other$i32)) {
            return false;
        }
        Uint64 this$u64 = this.getU64();
        Uint64 other$u64 = other.getU64();
        if (this$u64 == null ? other$u64 != null : !((Object)this$u64).equals(other$u64)) {
            return false;
        }
        Int64 this$i64 = this.getI64();
        Int64 other$i64 = other.getI64();
        if (this$i64 == null ? other$i64 != null : !((Object)this$i64).equals(other$i64)) {
            return false;
        }
        TimePoint this$timepoint = this.getTimepoint();
        TimePoint other$timepoint = other.getTimepoint();
        if (this$timepoint == null ? other$timepoint != null : !((Object)this$timepoint).equals(other$timepoint)) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        UInt128Parts this$u128 = this.getU128();
        UInt128Parts other$u128 = other.getU128();
        if (this$u128 == null ? other$u128 != null : !((Object)this$u128).equals(other$u128)) {
            return false;
        }
        Int128Parts this$i128 = this.getI128();
        Int128Parts other$i128 = other.getI128();
        if (this$i128 == null ? other$i128 != null : !((Object)this$i128).equals(other$i128)) {
            return false;
        }
        UInt256Parts this$u256 = this.getU256();
        UInt256Parts other$u256 = other.getU256();
        if (this$u256 == null ? other$u256 != null : !((Object)this$u256).equals(other$u256)) {
            return false;
        }
        Int256Parts this$i256 = this.getI256();
        Int256Parts other$i256 = other.getI256();
        if (this$i256 == null ? other$i256 != null : !((Object)this$i256).equals(other$i256)) {
            return false;
        }
        SCBytes this$bytes = this.getBytes();
        SCBytes other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes)) {
            return false;
        }
        SCString this$str = this.getStr();
        SCString other$str = other.getStr();
        if (this$str == null ? other$str != null : !((Object)this$str).equals(other$str)) {
            return false;
        }
        SCSymbol this$sym = this.getSym();
        SCSymbol other$sym = other.getSym();
        if (this$sym == null ? other$sym != null : !((Object)this$sym).equals(other$sym)) {
            return false;
        }
        SCVec this$vec = this.getVec();
        SCVec other$vec = other.getVec();
        if (this$vec == null ? other$vec != null : !((Object)this$vec).equals(other$vec)) {
            return false;
        }
        SCMap this$map = this.getMap();
        SCMap other$map = other.getMap();
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        SCAddress this$address = this.getAddress();
        SCAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        SCNonceKey this$nonce_key = this.getNonce_key();
        SCNonceKey other$nonce_key = other.getNonce_key();
        if (this$nonce_key == null ? other$nonce_key != null : !((Object)this$nonce_key).equals(other$nonce_key)) {
            return false;
        }
        SCContractInstance this$instance = this.getInstance();
        SCContractInstance other$instance = other.getInstance();
        return !(this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCVal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $b = this.getB();
        result = result * 59 + ($b == null ? 43 : ((Object)$b).hashCode());
        SCValType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        SCError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        Uint32 $u32 = this.getU32();
        result = result * 59 + ($u32 == null ? 43 : ((Object)$u32).hashCode());
        Int32 $i32 = this.getI32();
        result = result * 59 + ($i32 == null ? 43 : ((Object)$i32).hashCode());
        Uint64 $u64 = this.getU64();
        result = result * 59 + ($u64 == null ? 43 : ((Object)$u64).hashCode());
        Int64 $i64 = this.getI64();
        result = result * 59 + ($i64 == null ? 43 : ((Object)$i64).hashCode());
        TimePoint $timepoint = this.getTimepoint();
        result = result * 59 + ($timepoint == null ? 43 : ((Object)$timepoint).hashCode());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        UInt128Parts $u128 = this.getU128();
        result = result * 59 + ($u128 == null ? 43 : ((Object)$u128).hashCode());
        Int128Parts $i128 = this.getI128();
        result = result * 59 + ($i128 == null ? 43 : ((Object)$i128).hashCode());
        UInt256Parts $u256 = this.getU256();
        result = result * 59 + ($u256 == null ? 43 : ((Object)$u256).hashCode());
        Int256Parts $i256 = this.getI256();
        result = result * 59 + ($i256 == null ? 43 : ((Object)$i256).hashCode());
        SCBytes $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        SCString $str = this.getStr();
        result = result * 59 + ($str == null ? 43 : ((Object)$str).hashCode());
        SCSymbol $sym = this.getSym();
        result = result * 59 + ($sym == null ? 43 : ((Object)$sym).hashCode());
        SCVec $vec = this.getVec();
        result = result * 59 + ($vec == null ? 43 : ((Object)$vec).hashCode());
        SCMap $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        SCAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        SCNonceKey $nonce_key = this.getNonce_key();
        result = result * 59 + ($nonce_key == null ? 43 : ((Object)$nonce_key).hashCode());
        SCContractInstance $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCVal(discriminant=" + this.getDiscriminant() + ", b=" + this.getB() + ", error=" + this.getError() + ", u32=" + this.getU32() + ", i32=" + this.getI32() + ", u64=" + this.getU64() + ", i64=" + this.getI64() + ", timepoint=" + this.getTimepoint() + ", duration=" + this.getDuration() + ", u128=" + this.getU128() + ", i128=" + this.getI128() + ", u256=" + this.getU256() + ", i256=" + this.getI256() + ", bytes=" + this.getBytes() + ", str=" + this.getStr() + ", sym=" + this.getSym() + ", vec=" + this.getVec() + ", map=" + this.getMap() + ", address=" + this.getAddress() + ", nonce_key=" + this.getNonce_key() + ", instance=" + this.getInstance() + ")";
    }

    @Generated
    public SCVal() {
    }

    @Generated
    public SCVal(SCValType discriminant, Boolean b, SCError error, Uint32 u32, Int32 i32, Uint64 u64, Int64 i64, TimePoint timepoint, Duration duration, UInt128Parts u128, Int128Parts i128, UInt256Parts u256, Int256Parts i256, SCBytes bytes, SCString str, SCSymbol sym, SCVec vec, SCMap map, SCAddress address, SCNonceKey nonce_key, SCContractInstance instance) {
        this.discriminant = discriminant;
        this.b = b;
        this.error = error;
        this.u32 = u32;
        this.i32 = i32;
        this.u64 = u64;
        this.i64 = i64;
        this.timepoint = timepoint;
        this.duration = duration;
        this.u128 = u128;
        this.i128 = i128;
        this.u256 = u256;
        this.i256 = i256;
        this.bytes = bytes;
        this.str = str;
        this.sym = sym;
        this.vec = vec;
        this.map = map;
        this.address = address;
        this.nonce_key = nonce_key;
        this.instance = instance;
    }

    @Generated
    public static class SCValBuilder {
        @Generated
        private SCValType discriminant;
        @Generated
        private Boolean b;
        @Generated
        private SCError error;
        @Generated
        private Uint32 u32;
        @Generated
        private Int32 i32;
        @Generated
        private Uint64 u64;
        @Generated
        private Int64 i64;
        @Generated
        private TimePoint timepoint;
        @Generated
        private Duration duration;
        @Generated
        private UInt128Parts u128;
        @Generated
        private Int128Parts i128;
        @Generated
        private UInt256Parts u256;
        @Generated
        private Int256Parts i256;
        @Generated
        private SCBytes bytes;
        @Generated
        private SCString str;
        @Generated
        private SCSymbol sym;
        @Generated
        private SCVec vec;
        @Generated
        private SCMap map;
        @Generated
        private SCAddress address;
        @Generated
        private SCNonceKey nonce_key;
        @Generated
        private SCContractInstance instance;

        @Generated
        SCValBuilder() {
        }

        @Generated
        public SCValBuilder discriminant(SCValType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCValBuilder b(Boolean b) {
            this.b = b;
            return this;
        }

        @Generated
        public SCValBuilder error(SCError error) {
            this.error = error;
            return this;
        }

        @Generated
        public SCValBuilder u32(Uint32 u32) {
            this.u32 = u32;
            return this;
        }

        @Generated
        public SCValBuilder i32(Int32 i32) {
            this.i32 = i32;
            return this;
        }

        @Generated
        public SCValBuilder u64(Uint64 u64) {
            this.u64 = u64;
            return this;
        }

        @Generated
        public SCValBuilder i64(Int64 i64) {
            this.i64 = i64;
            return this;
        }

        @Generated
        public SCValBuilder timepoint(TimePoint timepoint) {
            this.timepoint = timepoint;
            return this;
        }

        @Generated
        public SCValBuilder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        @Generated
        public SCValBuilder u128(UInt128Parts u128) {
            this.u128 = u128;
            return this;
        }

        @Generated
        public SCValBuilder i128(Int128Parts i128) {
            this.i128 = i128;
            return this;
        }

        @Generated
        public SCValBuilder u256(UInt256Parts u256) {
            this.u256 = u256;
            return this;
        }

        @Generated
        public SCValBuilder i256(Int256Parts i256) {
            this.i256 = i256;
            return this;
        }

        @Generated
        public SCValBuilder bytes(SCBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        @Generated
        public SCValBuilder str(SCString str) {
            this.str = str;
            return this;
        }

        @Generated
        public SCValBuilder sym(SCSymbol sym) {
            this.sym = sym;
            return this;
        }

        @Generated
        public SCValBuilder vec(SCVec vec) {
            this.vec = vec;
            return this;
        }

        @Generated
        public SCValBuilder map(SCMap map) {
            this.map = map;
            return this;
        }

        @Generated
        public SCValBuilder address(SCAddress address) {
            this.address = address;
            return this;
        }

        @Generated
        public SCValBuilder nonce_key(SCNonceKey nonce_key) {
            this.nonce_key = nonce_key;
            return this;
        }

        @Generated
        public SCValBuilder instance(SCContractInstance instance) {
            this.instance = instance;
            return this;
        }

        @Generated
        public SCVal build() {
            return new SCVal(this.discriminant, this.b, this.error, this.u32, this.i32, this.u64, this.i64, this.timepoint, this.duration, this.u128, this.i128, this.u256, this.i256, this.bytes, this.str, this.sym, this.vec, this.map, this.address, this.nonce_key, this.instance);
        }

        @Generated
        public String toString() {
            return "SCVal.SCValBuilder(discriminant=" + this.discriminant + ", b=" + this.b + ", error=" + this.error + ", u32=" + this.u32 + ", i32=" + this.i32 + ", u64=" + this.u64 + ", i64=" + this.i64 + ", timepoint=" + this.timepoint + ", duration=" + this.duration + ", u128=" + this.u128 + ", i128=" + this.i128 + ", u256=" + this.u256 + ", i256=" + this.i256 + ", bytes=" + this.bytes + ", str=" + this.str + ", sym=" + this.sym + ", vec=" + this.vec + ", map=" + this.map + ", address=" + this.address + ", nonce_key=" + this.nonce_key + ", instance=" + this.instance + ")";
        }
    }
}

