/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SignerKeyType implements XdrElement
{
    SIGNER_KEY_TYPE_ED25519(0),
    SIGNER_KEY_TYPE_PRE_AUTH_TX(1),
    SIGNER_KEY_TYPE_HASH_X(2),
    SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD(3);

    private final int value;

    private SignerKeyType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SignerKeyType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SIGNER_KEY_TYPE_ED25519;
            }
            case 1: {
                return SIGNER_KEY_TYPE_PRE_AUTH_TX;
            }
            case 2: {
                return SIGNER_KEY_TYPE_HASH_X;
            }
            case 3: {
                return SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SignerKeyType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignerKeyType.fromXdrByteArray(bytes);
    }

    public static SignerKeyType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignerKeyType.decode(xdrDataInputStream);
    }
}

