/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TransactionResultPair;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResultSet
implements XdrElement {
    private TransactionResultPair[] results;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int resultsSize = this.getResults().length;
        stream.writeInt(resultsSize);
        for (int i = 0; i < resultsSize; ++i) {
            this.results[i].encode(stream);
        }
    }

    public static TransactionResultSet decode(XdrDataInputStream stream) throws IOException {
        TransactionResultSet decodedTransactionResultSet = new TransactionResultSet();
        int resultsSize = stream.readInt();
        decodedTransactionResultSet.results = new TransactionResultPair[resultsSize];
        for (int i = 0; i < resultsSize; ++i) {
            decodedTransactionResultSet.results[i] = TransactionResultPair.decode(stream);
        }
        return decodedTransactionResultSet;
    }

    public static TransactionResultSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResultSet.fromXdrByteArray(bytes);
    }

    public static TransactionResultSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResultSet.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionResultSetBuilder builder() {
        return new TransactionResultSetBuilder();
    }

    @Generated
    public TransactionResultSetBuilder toBuilder() {
        return new TransactionResultSetBuilder().results(this.results);
    }

    @Generated
    public TransactionResultPair[] getResults() {
        return this.results;
    }

    @Generated
    public void setResults(TransactionResultPair[] results) {
        this.results = results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResultSet)) {
            return false;
        }
        TransactionResultSet other = (TransactionResultSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getResults(), other.getResults());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResultSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionResultSet(results=" + Arrays.deepToString(this.getResults()) + ")";
    }

    @Generated
    public TransactionResultSet() {
    }

    @Generated
    public TransactionResultSet(TransactionResultPair[] results) {
        this.results = results;
    }

    @Generated
    public static class TransactionResultSetBuilder {
        @Generated
        private TransactionResultPair[] results;

        @Generated
        TransactionResultSetBuilder() {
        }

        @Generated
        public TransactionResultSetBuilder results(TransactionResultPair[] results) {
            this.results = results;
            return this;
        }

        @Generated
        public TransactionResultSet build() {
            return new TransactionResultSet(this.results);
        }

        @Generated
        public String toString() {
            return "TransactionResultSet.TransactionResultSetBuilder(results=" + Arrays.deepToString(this.results) + ")";
        }
    }
}

