/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ArchivalProofType implements XdrElement
{
    EXISTENCE(0),
    NONEXISTENCE(1);

    private final int value;

    private ArchivalProofType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ArchivalProofType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return EXISTENCE;
            }
            case 1: {
                return NONEXISTENCE;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ArchivalProofType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ArchivalProofType.fromXdrByteArray(bytes);
    }

    public static ArchivalProofType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ArchivalProofType.decode(xdrDataInputStream);
    }
}

