/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InflationPayout
implements XdrElement {
    private AccountID destination;
    private Int64 amount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.destination.encode(stream);
        this.amount.encode(stream);
    }

    public static InflationPayout decode(XdrDataInputStream stream) throws IOException {
        InflationPayout decodedInflationPayout = new InflationPayout();
        decodedInflationPayout.destination = AccountID.decode(stream);
        decodedInflationPayout.amount = Int64.decode(stream);
        return decodedInflationPayout;
    }

    public static InflationPayout fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InflationPayout.fromXdrByteArray(bytes);
    }

    public static InflationPayout fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InflationPayout.decode(xdrDataInputStream);
    }

    @Generated
    public static InflationPayoutBuilder builder() {
        return new InflationPayoutBuilder();
    }

    @Generated
    public InflationPayoutBuilder toBuilder() {
        return new InflationPayoutBuilder().destination(this.destination).amount(this.amount);
    }

    @Generated
    public AccountID getDestination() {
        return this.destination;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public void setDestination(AccountID destination) {
        this.destination = destination;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InflationPayout)) {
            return false;
        }
        InflationPayout other = (InflationPayout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$destination = this.getDestination();
        AccountID other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InflationPayout;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InflationPayout(destination=" + this.getDestination() + ", amount=" + this.getAmount() + ")";
    }

    @Generated
    public InflationPayout() {
    }

    @Generated
    public InflationPayout(AccountID destination, Int64 amount) {
        this.destination = destination;
        this.amount = amount;
    }

    @Generated
    public static class InflationPayoutBuilder {
        @Generated
        private AccountID destination;
        @Generated
        private Int64 amount;

        @Generated
        InflationPayoutBuilder() {
        }

        @Generated
        public InflationPayoutBuilder destination(AccountID destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public InflationPayoutBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public InflationPayout build() {
            return new InflationPayout(this.destination, this.amount);
        }

        @Generated
        public String toString() {
            return "InflationPayout.InflationPayoutBuilder(destination=" + this.destination + ", amount=" + this.amount + ")";
        }
    }
}

