/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ColdArchiveBucketEntry;
import org.stellar.sdk.xdr.ProofLevel;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class NonexistenceProofBody
implements XdrElement {
    private ColdArchiveBucketEntry[] entriesToProve;
    private ProofLevel[] proofLevels;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int entriesToProveSize = this.getEntriesToProve().length;
        stream.writeInt(entriesToProveSize);
        for (int i = 0; i < entriesToProveSize; ++i) {
            this.entriesToProve[i].encode(stream);
        }
        int proofLevelsSize = this.getProofLevels().length;
        stream.writeInt(proofLevelsSize);
        for (int i = 0; i < proofLevelsSize; ++i) {
            this.proofLevels[i].encode(stream);
        }
    }

    public static NonexistenceProofBody decode(XdrDataInputStream stream) throws IOException {
        NonexistenceProofBody decodedNonexistenceProofBody = new NonexistenceProofBody();
        int entriesToProveSize = stream.readInt();
        decodedNonexistenceProofBody.entriesToProve = new ColdArchiveBucketEntry[entriesToProveSize];
        for (int i = 0; i < entriesToProveSize; ++i) {
            decodedNonexistenceProofBody.entriesToProve[i] = ColdArchiveBucketEntry.decode(stream);
        }
        int proofLevelsSize = stream.readInt();
        decodedNonexistenceProofBody.proofLevels = new ProofLevel[proofLevelsSize];
        for (int i = 0; i < proofLevelsSize; ++i) {
            decodedNonexistenceProofBody.proofLevels[i] = ProofLevel.decode(stream);
        }
        return decodedNonexistenceProofBody;
    }

    public static NonexistenceProofBody fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return NonexistenceProofBody.fromXdrByteArray(bytes);
    }

    public static NonexistenceProofBody fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return NonexistenceProofBody.decode(xdrDataInputStream);
    }

    @Generated
    public static NonexistenceProofBodyBuilder builder() {
        return new NonexistenceProofBodyBuilder();
    }

    @Generated
    public NonexistenceProofBodyBuilder toBuilder() {
        return new NonexistenceProofBodyBuilder().entriesToProve(this.entriesToProve).proofLevels(this.proofLevels);
    }

    @Generated
    public ColdArchiveBucketEntry[] getEntriesToProve() {
        return this.entriesToProve;
    }

    @Generated
    public ProofLevel[] getProofLevels() {
        return this.proofLevels;
    }

    @Generated
    public void setEntriesToProve(ColdArchiveBucketEntry[] entriesToProve) {
        this.entriesToProve = entriesToProve;
    }

    @Generated
    public void setProofLevels(ProofLevel[] proofLevels) {
        this.proofLevels = proofLevels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonexistenceProofBody)) {
            return false;
        }
        NonexistenceProofBody other = (NonexistenceProofBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEntriesToProve(), other.getEntriesToProve())) {
            return false;
        }
        return Arrays.deepEquals(this.getProofLevels(), other.getProofLevels());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NonexistenceProofBody;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEntriesToProve());
        result = result * 59 + Arrays.deepHashCode(this.getProofLevels());
        return result;
    }

    @Generated
    public String toString() {
        return "NonexistenceProofBody(entriesToProve=" + Arrays.deepToString(this.getEntriesToProve()) + ", proofLevels=" + Arrays.deepToString(this.getProofLevels()) + ")";
    }

    @Generated
    public NonexistenceProofBody() {
    }

    @Generated
    public NonexistenceProofBody(ColdArchiveBucketEntry[] entriesToProve, ProofLevel[] proofLevels) {
        this.entriesToProve = entriesToProve;
        this.proofLevels = proofLevels;
    }

    @Generated
    public static class NonexistenceProofBodyBuilder {
        @Generated
        private ColdArchiveBucketEntry[] entriesToProve;
        @Generated
        private ProofLevel[] proofLevels;

        @Generated
        NonexistenceProofBodyBuilder() {
        }

        @Generated
        public NonexistenceProofBodyBuilder entriesToProve(ColdArchiveBucketEntry[] entriesToProve) {
            this.entriesToProve = entriesToProve;
            return this;
        }

        @Generated
        public NonexistenceProofBodyBuilder proofLevels(ProofLevel[] proofLevels) {
            this.proofLevels = proofLevels;
            return this;
        }

        @Generated
        public NonexistenceProofBody build() {
            return new NonexistenceProofBody(this.entriesToProve, this.proofLevels);
        }

        @Generated
        public String toString() {
            return "NonexistenceProofBody.NonexistenceProofBodyBuilder(entriesToProve=" + Arrays.deepToString(this.entriesToProve) + ", proofLevels=" + Arrays.deepToString(this.proofLevels) + ")";
        }
    }
}

