/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPStatement;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPEnvelope
implements XdrElement {
    private SCPStatement statement;
    private Signature signature;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.statement.encode(stream);
        this.signature.encode(stream);
    }

    public static SCPEnvelope decode(XdrDataInputStream stream) throws IOException {
        SCPEnvelope decodedSCPEnvelope = new SCPEnvelope();
        decodedSCPEnvelope.statement = SCPStatement.decode(stream);
        decodedSCPEnvelope.signature = Signature.decode(stream);
        return decodedSCPEnvelope;
    }

    public static SCPEnvelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPEnvelope.fromXdrByteArray(bytes);
    }

    public static SCPEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPEnvelope.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPEnvelopeBuilder builder() {
        return new SCPEnvelopeBuilder();
    }

    @Generated
    public SCPEnvelopeBuilder toBuilder() {
        return new SCPEnvelopeBuilder().statement(this.statement).signature(this.signature);
    }

    @Generated
    public SCPStatement getStatement() {
        return this.statement;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public void setStatement(SCPStatement statement) {
        this.statement = statement;
    }

    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPEnvelope)) {
            return false;
        }
        SCPEnvelope other = (SCPEnvelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCPStatement this$statement = this.getStatement();
        SCPStatement other$statement = other.getStatement();
        if (this$statement == null ? other$statement != null : !((Object)this$statement).equals(other$statement)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPEnvelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCPStatement $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : ((Object)$statement).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPEnvelope(statement=" + this.getStatement() + ", signature=" + this.getSignature() + ")";
    }

    @Generated
    public SCPEnvelope() {
    }

    @Generated
    public SCPEnvelope(SCPStatement statement, Signature signature) {
        this.statement = statement;
        this.signature = signature;
    }

    @Generated
    public static class SCPEnvelopeBuilder {
        @Generated
        private SCPStatement statement;
        @Generated
        private Signature signature;

        @Generated
        SCPEnvelopeBuilder() {
        }

        @Generated
        public SCPEnvelopeBuilder statement(SCPStatement statement) {
            this.statement = statement;
            return this;
        }

        @Generated
        public SCPEnvelopeBuilder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public SCPEnvelope build() {
            return new SCPEnvelope(this.statement, this.signature);
        }

        @Generated
        public String toString() {
            return "SCPEnvelope.SCPEnvelopeBuilder(statement=" + this.statement + ", signature=" + this.signature + ")";
        }
    }
}

