/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SurveyResponseMessage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SignedSurveyResponseMessage
implements XdrElement {
    private Signature responseSignature;
    private SurveyResponseMessage response;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.responseSignature.encode(stream);
        this.response.encode(stream);
    }

    public static SignedSurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
        SignedSurveyResponseMessage decodedSignedSurveyResponseMessage = new SignedSurveyResponseMessage();
        decodedSignedSurveyResponseMessage.responseSignature = Signature.decode(stream);
        decodedSignedSurveyResponseMessage.response = SurveyResponseMessage.decode(stream);
        return decodedSignedSurveyResponseMessage;
    }

    public static SignedSurveyResponseMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignedSurveyResponseMessage.fromXdrByteArray(bytes);
    }

    public static SignedSurveyResponseMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignedSurveyResponseMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static SignedSurveyResponseMessageBuilder builder() {
        return new SignedSurveyResponseMessageBuilder();
    }

    @Generated
    public SignedSurveyResponseMessageBuilder toBuilder() {
        return new SignedSurveyResponseMessageBuilder().responseSignature(this.responseSignature).response(this.response);
    }

    @Generated
    public Signature getResponseSignature() {
        return this.responseSignature;
    }

    @Generated
    public SurveyResponseMessage getResponse() {
        return this.response;
    }

    @Generated
    public void setResponseSignature(Signature responseSignature) {
        this.responseSignature = responseSignature;
    }

    @Generated
    public void setResponse(SurveyResponseMessage response) {
        this.response = response;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedSurveyResponseMessage)) {
            return false;
        }
        SignedSurveyResponseMessage other = (SignedSurveyResponseMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Signature this$responseSignature = this.getResponseSignature();
        Signature other$responseSignature = other.getResponseSignature();
        if (this$responseSignature == null ? other$responseSignature != null : !((Object)this$responseSignature).equals(other$responseSignature)) {
            return false;
        }
        SurveyResponseMessage this$response = this.getResponse();
        SurveyResponseMessage other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignedSurveyResponseMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Signature $responseSignature = this.getResponseSignature();
        result = result * 59 + ($responseSignature == null ? 43 : ((Object)$responseSignature).hashCode());
        SurveyResponseMessage $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignedSurveyResponseMessage(responseSignature=" + this.getResponseSignature() + ", response=" + this.getResponse() + ")";
    }

    @Generated
    public SignedSurveyResponseMessage() {
    }

    @Generated
    public SignedSurveyResponseMessage(Signature responseSignature, SurveyResponseMessage response) {
        this.responseSignature = responseSignature;
        this.response = response;
    }

    @Generated
    public static class SignedSurveyResponseMessageBuilder {
        @Generated
        private Signature responseSignature;
        @Generated
        private SurveyResponseMessage response;

        @Generated
        SignedSurveyResponseMessageBuilder() {
        }

        @Generated
        public SignedSurveyResponseMessageBuilder responseSignature(Signature responseSignature) {
            this.responseSignature = responseSignature;
            return this;
        }

        @Generated
        public SignedSurveyResponseMessageBuilder response(SurveyResponseMessage response) {
            this.response = response;
            return this;
        }

        @Generated
        public SignedSurveyResponseMessage build() {
            return new SignedSurveyResponseMessage(this.responseSignature, this.response);
        }

        @Generated
        public String toString() {
            return "SignedSurveyResponseMessage.SignedSurveyResponseMessageBuilder(responseSignature=" + this.responseSignature + ", response=" + this.response + ")";
        }
    }
}

