/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.LedgerUpgrade;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class UpgradeEntryMeta
implements XdrElement {
    private LedgerUpgrade upgrade;
    private LedgerEntryChanges changes;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.upgrade.encode(stream);
        this.changes.encode(stream);
    }

    public static UpgradeEntryMeta decode(XdrDataInputStream stream) throws IOException {
        UpgradeEntryMeta decodedUpgradeEntryMeta = new UpgradeEntryMeta();
        decodedUpgradeEntryMeta.upgrade = LedgerUpgrade.decode(stream);
        decodedUpgradeEntryMeta.changes = LedgerEntryChanges.decode(stream);
        return decodedUpgradeEntryMeta;
    }

    public static UpgradeEntryMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return UpgradeEntryMeta.fromXdrByteArray(bytes);
    }

    public static UpgradeEntryMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return UpgradeEntryMeta.decode(xdrDataInputStream);
    }

    @Generated
    public static UpgradeEntryMetaBuilder builder() {
        return new UpgradeEntryMetaBuilder();
    }

    @Generated
    public UpgradeEntryMetaBuilder toBuilder() {
        return new UpgradeEntryMetaBuilder().upgrade(this.upgrade).changes(this.changes);
    }

    @Generated
    public LedgerUpgrade getUpgrade() {
        return this.upgrade;
    }

    @Generated
    public LedgerEntryChanges getChanges() {
        return this.changes;
    }

    @Generated
    public void setUpgrade(LedgerUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    @Generated
    public void setChanges(LedgerEntryChanges changes) {
        this.changes = changes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeEntryMeta)) {
            return false;
        }
        UpgradeEntryMeta other = (UpgradeEntryMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerUpgrade this$upgrade = this.getUpgrade();
        LedgerUpgrade other$upgrade = other.getUpgrade();
        if (this$upgrade == null ? other$upgrade != null : !((Object)this$upgrade).equals(other$upgrade)) {
            return false;
        }
        LedgerEntryChanges this$changes = this.getChanges();
        LedgerEntryChanges other$changes = other.getChanges();
        return !(this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeEntryMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerUpgrade $upgrade = this.getUpgrade();
        result = result * 59 + ($upgrade == null ? 43 : ((Object)$upgrade).hashCode());
        LedgerEntryChanges $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UpgradeEntryMeta(upgrade=" + this.getUpgrade() + ", changes=" + this.getChanges() + ")";
    }

    @Generated
    public UpgradeEntryMeta() {
    }

    @Generated
    public UpgradeEntryMeta(LedgerUpgrade upgrade, LedgerEntryChanges changes) {
        this.upgrade = upgrade;
        this.changes = changes;
    }

    @Generated
    public static class UpgradeEntryMetaBuilder {
        @Generated
        private LedgerUpgrade upgrade;
        @Generated
        private LedgerEntryChanges changes;

        @Generated
        UpgradeEntryMetaBuilder() {
        }

        @Generated
        public UpgradeEntryMetaBuilder upgrade(LedgerUpgrade upgrade) {
            this.upgrade = upgrade;
            return this;
        }

        @Generated
        public UpgradeEntryMetaBuilder changes(LedgerEntryChanges changes) {
            this.changes = changes;
            return this;
        }

        @Generated
        public UpgradeEntryMeta build() {
            return new UpgradeEntryMeta(this.upgrade, this.changes);
        }

        @Generated
        public String toString() {
            return "UpgradeEntryMeta.UpgradeEntryMetaBuilder(upgrade=" + this.upgrade + ", changes=" + this.changes + ")";
        }
    }
}

