// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerKey's original definition in the XDR file is:
 *
 * <pre>
 * union LedgerKey switch (LedgerEntryType type)
 * {
 * case ACCOUNT:
 *     struct
 *     {
 *         AccountID accountID;
 *     } account;
 *
 * case TRUSTLINE:
 *     struct
 *     {
 *         AccountID accountID;
 *         TrustLineAsset asset;
 *     } trustLine;
 *
 * case OFFER:
 *     struct
 *     {
 *         AccountID sellerID;
 *         int64 offerID;
 *     } offer;
 *
 * case DATA:
 *     struct
 *     {
 *         AccountID accountID;
 *         string64 dataName;
 *     } data;
 *
 * case CLAIMABLE_BALANCE:
 *     struct
 *     {
 *         ClaimableBalanceID balanceID;
 *     } claimableBalance;
 *
 * case LIQUIDITY_POOL:
 *     struct
 *     {
 *         PoolID liquidityPoolID;
 *     } liquidityPool;
 * case CONTRACT_DATA:
 *     struct
 *     {
 *         SCAddress contract;
 *         SCVal key;
 *         ContractDataDurability durability;
 *     } contractData;
 * case CONTRACT_CODE:
 *     struct
 *     {
 *         Hash hash;
 *     } contractCode;
 * case CONFIG_SETTING:
 *     struct
 *     {
 *         ConfigSettingID configSettingID;
 *     } configSetting;
 * case TTL:
 *     struct
 *     {
 *         // Hash of the LedgerKey that is associated with this TTLEntry
 *         Hash keyHash;
 *     } ttl;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerKey implements XdrElement {
  private LedgerEntryType discriminant;
  private LedgerKeyAccount account;
  private LedgerKeyTrustLine trustLine;
  private LedgerKeyOffer offer;
  private LedgerKeyData data;
  private LedgerKeyClaimableBalance claimableBalance;
  private LedgerKeyLiquidityPool liquidityPool;
  private LedgerKeyContractData contractData;
  private LedgerKeyContractCode contractCode;
  private LedgerKeyConfigSetting configSetting;
  private LedgerKeyTtl ttl;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ACCOUNT:
        account.encode(stream);
        break;
      case TRUSTLINE:
        trustLine.encode(stream);
        break;
      case OFFER:
        offer.encode(stream);
        break;
      case DATA:
        data.encode(stream);
        break;
      case CLAIMABLE_BALANCE:
        claimableBalance.encode(stream);
        break;
      case LIQUIDITY_POOL:
        liquidityPool.encode(stream);
        break;
      case CONTRACT_DATA:
        contractData.encode(stream);
        break;
      case CONTRACT_CODE:
        contractCode.encode(stream);
        break;
      case CONFIG_SETTING:
        configSetting.encode(stream);
        break;
      case TTL:
        ttl.encode(stream);
        break;
    }
  }

  public static LedgerKey decode(XdrDataInputStream stream) throws IOException {
    LedgerKey decodedLedgerKey = new LedgerKey();
    LedgerEntryType discriminant = LedgerEntryType.decode(stream);
    decodedLedgerKey.setDiscriminant(discriminant);
    switch (decodedLedgerKey.getDiscriminant()) {
      case ACCOUNT:
        decodedLedgerKey.account = LedgerKeyAccount.decode(stream);
        break;
      case TRUSTLINE:
        decodedLedgerKey.trustLine = LedgerKeyTrustLine.decode(stream);
        break;
      case OFFER:
        decodedLedgerKey.offer = LedgerKeyOffer.decode(stream);
        break;
      case DATA:
        decodedLedgerKey.data = LedgerKeyData.decode(stream);
        break;
      case CLAIMABLE_BALANCE:
        decodedLedgerKey.claimableBalance = LedgerKeyClaimableBalance.decode(stream);
        break;
      case LIQUIDITY_POOL:
        decodedLedgerKey.liquidityPool = LedgerKeyLiquidityPool.decode(stream);
        break;
      case CONTRACT_DATA:
        decodedLedgerKey.contractData = LedgerKeyContractData.decode(stream);
        break;
      case CONTRACT_CODE:
        decodedLedgerKey.contractCode = LedgerKeyContractCode.decode(stream);
        break;
      case CONFIG_SETTING:
        decodedLedgerKey.configSetting = LedgerKeyConfigSetting.decode(stream);
        break;
      case TTL:
        decodedLedgerKey.ttl = LedgerKeyTtl.decode(stream);
        break;
    }
    return decodedLedgerKey;
  }

  public static LedgerKey fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerKey fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LedgerKeyAccount's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID accountID;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyAccount implements XdrElement {
    private AccountID accountID;

    public void encode(XdrDataOutputStream stream) throws IOException {
      accountID.encode(stream);
    }

    public static LedgerKeyAccount decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyAccount decodedLedgerKeyAccount = new LedgerKeyAccount();
      decodedLedgerKeyAccount.accountID = AccountID.decode(stream);
      return decodedLedgerKeyAccount;
    }

    public static LedgerKeyAccount fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyAccount fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyTrustLine's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID accountID;
   *         TrustLineAsset asset;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyTrustLine implements XdrElement {
    private AccountID accountID;
    private TrustLineAsset asset;

    public void encode(XdrDataOutputStream stream) throws IOException {
      accountID.encode(stream);
      asset.encode(stream);
    }

    public static LedgerKeyTrustLine decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyTrustLine decodedLedgerKeyTrustLine = new LedgerKeyTrustLine();
      decodedLedgerKeyTrustLine.accountID = AccountID.decode(stream);
      decodedLedgerKeyTrustLine.asset = TrustLineAsset.decode(stream);
      return decodedLedgerKeyTrustLine;
    }

    public static LedgerKeyTrustLine fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyTrustLine fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyOffer's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID sellerID;
   *         int64 offerID;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyOffer implements XdrElement {
    private AccountID sellerID;
    private Int64 offerID;

    public void encode(XdrDataOutputStream stream) throws IOException {
      sellerID.encode(stream);
      offerID.encode(stream);
    }

    public static LedgerKeyOffer decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyOffer decodedLedgerKeyOffer = new LedgerKeyOffer();
      decodedLedgerKeyOffer.sellerID = AccountID.decode(stream);
      decodedLedgerKeyOffer.offerID = Int64.decode(stream);
      return decodedLedgerKeyOffer;
    }

    public static LedgerKeyOffer fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyOffer fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyData's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID accountID;
   *         string64 dataName;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyData implements XdrElement {
    private AccountID accountID;
    private String64 dataName;

    public void encode(XdrDataOutputStream stream) throws IOException {
      accountID.encode(stream);
      dataName.encode(stream);
    }

    public static LedgerKeyData decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyData decodedLedgerKeyData = new LedgerKeyData();
      decodedLedgerKeyData.accountID = AccountID.decode(stream);
      decodedLedgerKeyData.dataName = String64.decode(stream);
      return decodedLedgerKeyData;
    }

    public static LedgerKeyData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyClaimableBalance's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         ClaimableBalanceID balanceID;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyClaimableBalance implements XdrElement {
    private ClaimableBalanceID balanceID;

    public void encode(XdrDataOutputStream stream) throws IOException {
      balanceID.encode(stream);
    }

    public static LedgerKeyClaimableBalance decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyClaimableBalance decodedLedgerKeyClaimableBalance = new LedgerKeyClaimableBalance();
      decodedLedgerKeyClaimableBalance.balanceID = ClaimableBalanceID.decode(stream);
      return decodedLedgerKeyClaimableBalance;
    }

    public static LedgerKeyClaimableBalance fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyClaimableBalance fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyLiquidityPool's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         PoolID liquidityPoolID;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyLiquidityPool implements XdrElement {
    private PoolID liquidityPoolID;

    public void encode(XdrDataOutputStream stream) throws IOException {
      liquidityPoolID.encode(stream);
    }

    public static LedgerKeyLiquidityPool decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyLiquidityPool decodedLedgerKeyLiquidityPool = new LedgerKeyLiquidityPool();
      decodedLedgerKeyLiquidityPool.liquidityPoolID = PoolID.decode(stream);
      return decodedLedgerKeyLiquidityPool;
    }

    public static LedgerKeyLiquidityPool fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyLiquidityPool fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyContractData's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         SCAddress contract;
   *         SCVal key;
   *         ContractDataDurability durability;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyContractData implements XdrElement {
    private SCAddress contract;
    private SCVal key;
    private ContractDataDurability durability;

    public void encode(XdrDataOutputStream stream) throws IOException {
      contract.encode(stream);
      key.encode(stream);
      durability.encode(stream);
    }

    public static LedgerKeyContractData decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyContractData decodedLedgerKeyContractData = new LedgerKeyContractData();
      decodedLedgerKeyContractData.contract = SCAddress.decode(stream);
      decodedLedgerKeyContractData.key = SCVal.decode(stream);
      decodedLedgerKeyContractData.durability = ContractDataDurability.decode(stream);
      return decodedLedgerKeyContractData;
    }

    public static LedgerKeyContractData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyContractData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyContractCode's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         Hash hash;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyContractCode implements XdrElement {
    private Hash hash;

    public void encode(XdrDataOutputStream stream) throws IOException {
      hash.encode(stream);
    }

    public static LedgerKeyContractCode decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyContractCode decodedLedgerKeyContractCode = new LedgerKeyContractCode();
      decodedLedgerKeyContractCode.hash = Hash.decode(stream);
      return decodedLedgerKeyContractCode;
    }

    public static LedgerKeyContractCode fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyContractCode fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyConfigSetting's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         ConfigSettingID configSettingID;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyConfigSetting implements XdrElement {
    private ConfigSettingID configSettingID;

    public void encode(XdrDataOutputStream stream) throws IOException {
      configSettingID.encode(stream);
    }

    public static LedgerKeyConfigSetting decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyConfigSetting decodedLedgerKeyConfigSetting = new LedgerKeyConfigSetting();
      decodedLedgerKeyConfigSetting.configSettingID = ConfigSettingID.decode(stream);
      return decodedLedgerKeyConfigSetting;
    }

    public static LedgerKeyConfigSetting fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyConfigSetting fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerKeyTtl's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         // Hash of the LedgerKey that is associated with this TTLEntry
   *         Hash keyHash;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerKeyTtl implements XdrElement {
    private Hash keyHash;

    public void encode(XdrDataOutputStream stream) throws IOException {
      keyHash.encode(stream);
    }

    public static LedgerKeyTtl decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyTtl decodedLedgerKeyTtl = new LedgerKeyTtl();
      decodedLedgerKeyTtl.keyHash = Hash.decode(stream);
      return decodedLedgerKeyTtl;
    }

    public static LedgerKeyTtl fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyTtl fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
