// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Preconditions's original definition in the XDR file is:
 *
 * <pre>
 * union Preconditions switch (PreconditionType type)
 * {
 * case PRECOND_NONE:
 *     void;
 * case PRECOND_TIME:
 *     TimeBounds timeBounds;
 * case PRECOND_V2:
 *     PreconditionsV2 v2;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Preconditions implements XdrElement {
  private PreconditionType discriminant;
  private TimeBounds timeBounds;
  private PreconditionsV2 v2;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case PRECOND_NONE:
        break;
      case PRECOND_TIME:
        timeBounds.encode(stream);
        break;
      case PRECOND_V2:
        v2.encode(stream);
        break;
    }
  }

  public static Preconditions decode(XdrDataInputStream stream) throws IOException {
    Preconditions decodedPreconditions = new Preconditions();
    PreconditionType discriminant = PreconditionType.decode(stream);
    decodedPreconditions.setDiscriminant(discriminant);
    switch (decodedPreconditions.getDiscriminant()) {
      case PRECOND_NONE:
        break;
      case PRECOND_TIME:
        decodedPreconditions.timeBounds = TimeBounds.decode(stream);
        break;
      case PRECOND_V2:
        decodedPreconditions.v2 = PreconditionsV2.decode(stream);
        break;
    }
    return decodedPreconditions;
  }

  public static Preconditions fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Preconditions fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
