// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCMetaEntry's original definition in the XDR file is:
 *
 * <pre>
 * union SCMetaEntry switch (SCMetaKind kind)
 * {
 * case SC_META_V0:
 *     SCMetaV0 v0;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCMetaEntry implements XdrElement {
  private SCMetaKind discriminant;
  private SCMetaV0 v0;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SC_META_V0:
        v0.encode(stream);
        break;
    }
  }

  public static SCMetaEntry decode(XdrDataInputStream stream) throws IOException {
    SCMetaEntry decodedSCMetaEntry = new SCMetaEntry();
    SCMetaKind discriminant = SCMetaKind.decode(stream);
    decodedSCMetaEntry.setDiscriminant(discriminant);
    switch (decodedSCMetaEntry.getDiscriminant()) {
      case SC_META_V0:
        decodedSCMetaEntry.v0 = SCMetaV0.decode(stream);
        break;
    }
    return decodedSCMetaEntry;
  }

  public static SCMetaEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
