// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SetOptionsOp's original definition in the XDR file is:
 *
 * <pre>
 * struct SetOptionsOp
 * {
 *     AccountID&#42; inflationDest; // sets the inflation destination
 *
 *     uint32&#42; clearFlags; // which flags to clear
 *     uint32&#42; setFlags;   // which flags to set
 *
 *     // account threshold manipulation
 *     uint32&#42; masterWeight; // weight of the master account
 *     uint32&#42; lowThreshold;
 *     uint32&#42; medThreshold;
 *     uint32&#42; highThreshold;
 *
 *     string32&#42; homeDomain; // sets the home domain
 *
 *     // Add, update or remove a signer for the account
 *     // signer is deleted if the weight is 0
 *     Signer&#42; signer;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SetOptionsOp implements XdrElement {
  private AccountID inflationDest;
  private Uint32 clearFlags;
  private Uint32 setFlags;
  private Uint32 masterWeight;
  private Uint32 lowThreshold;
  private Uint32 medThreshold;
  private Uint32 highThreshold;
  private String32 homeDomain;
  private Signer signer;

  public void encode(XdrDataOutputStream stream) throws IOException {
    if (inflationDest != null) {
      stream.writeInt(1);
      inflationDest.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (clearFlags != null) {
      stream.writeInt(1);
      clearFlags.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (setFlags != null) {
      stream.writeInt(1);
      setFlags.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (masterWeight != null) {
      stream.writeInt(1);
      masterWeight.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (lowThreshold != null) {
      stream.writeInt(1);
      lowThreshold.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (medThreshold != null) {
      stream.writeInt(1);
      medThreshold.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (highThreshold != null) {
      stream.writeInt(1);
      highThreshold.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (homeDomain != null) {
      stream.writeInt(1);
      homeDomain.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (signer != null) {
      stream.writeInt(1);
      signer.encode(stream);
    } else {
      stream.writeInt(0);
    }
  }

  public static SetOptionsOp decode(XdrDataInputStream stream) throws IOException {
    SetOptionsOp decodedSetOptionsOp = new SetOptionsOp();
    int inflationDestPresent = stream.readInt();
    if (inflationDestPresent != 0) {
      decodedSetOptionsOp.inflationDest = AccountID.decode(stream);
    }
    int clearFlagsPresent = stream.readInt();
    if (clearFlagsPresent != 0) {
      decodedSetOptionsOp.clearFlags = Uint32.decode(stream);
    }
    int setFlagsPresent = stream.readInt();
    if (setFlagsPresent != 0) {
      decodedSetOptionsOp.setFlags = Uint32.decode(stream);
    }
    int masterWeightPresent = stream.readInt();
    if (masterWeightPresent != 0) {
      decodedSetOptionsOp.masterWeight = Uint32.decode(stream);
    }
    int lowThresholdPresent = stream.readInt();
    if (lowThresholdPresent != 0) {
      decodedSetOptionsOp.lowThreshold = Uint32.decode(stream);
    }
    int medThresholdPresent = stream.readInt();
    if (medThresholdPresent != 0) {
      decodedSetOptionsOp.medThreshold = Uint32.decode(stream);
    }
    int highThresholdPresent = stream.readInt();
    if (highThresholdPresent != 0) {
      decodedSetOptionsOp.highThreshold = Uint32.decode(stream);
    }
    int homeDomainPresent = stream.readInt();
    if (homeDomainPresent != 0) {
      decodedSetOptionsOp.homeDomain = String32.decode(stream);
    }
    int signerPresent = stream.readInt();
    if (signerPresent != 0) {
      decodedSetOptionsOp.signer = Signer.decode(stream);
    }
    return decodedSetOptionsOp;
  }

  public static SetOptionsOp fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SetOptionsOp fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
