// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ShortHashSeed's original definition in the XDR file is:
 *
 * <pre>
 * struct ShortHashSeed
 * {
 *     opaque seed[16];
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ShortHashSeed implements XdrElement {
  private byte[] seed;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int seedSize = seed.length;
    stream.write(getSeed(), 0, seedSize);
  }

  public static ShortHashSeed decode(XdrDataInputStream stream) throws IOException {
    ShortHashSeed decodedShortHashSeed = new ShortHashSeed();
    int seedSize = 16;
    decodedShortHashSeed.seed = new byte[seedSize];
    stream.read(decodedShortHashSeed.seed, 0, seedSize);
    return decodedShortHashSeed;
  }

  public static ShortHashSeed fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ShortHashSeed fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
