/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimableBalanceEntryExtensionV1;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimableBalanceEntry
implements XdrElement {
    private ClaimableBalanceID balanceID;
    private Claimant[] claimants;
    private Asset asset;
    private Int64 amount;
    private ClaimableBalanceEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.balanceID.encode(stream);
        int claimantsSize = this.getClaimants().length;
        stream.writeInt(claimantsSize);
        for (int i = 0; i < claimantsSize; ++i) {
            this.claimants[i].encode(stream);
        }
        this.asset.encode(stream);
        this.amount.encode(stream);
        this.ext.encode(stream);
    }

    public static ClaimableBalanceEntry decode(XdrDataInputStream stream) throws IOException {
        ClaimableBalanceEntry decodedClaimableBalanceEntry = new ClaimableBalanceEntry();
        decodedClaimableBalanceEntry.balanceID = ClaimableBalanceID.decode(stream);
        int claimantsSize = stream.readInt();
        decodedClaimableBalanceEntry.claimants = new Claimant[claimantsSize];
        for (int i = 0; i < claimantsSize; ++i) {
            decodedClaimableBalanceEntry.claimants[i] = Claimant.decode(stream);
        }
        decodedClaimableBalanceEntry.asset = Asset.decode(stream);
        decodedClaimableBalanceEntry.amount = Int64.decode(stream);
        decodedClaimableBalanceEntry.ext = ClaimableBalanceEntryExt.decode(stream);
        return decodedClaimableBalanceEntry;
    }

    public static ClaimableBalanceEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimableBalanceEntry.fromXdrByteArray(bytes);
    }

    public static ClaimableBalanceEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimableBalanceEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimableBalanceEntryBuilder builder() {
        return new ClaimableBalanceEntryBuilder();
    }

    @Generated
    public ClaimableBalanceEntryBuilder toBuilder() {
        return new ClaimableBalanceEntryBuilder().balanceID(this.balanceID).claimants(this.claimants).asset(this.asset).amount(this.amount).ext(this.ext);
    }

    @Generated
    public ClaimableBalanceID getBalanceID() {
        return this.balanceID;
    }

    @Generated
    public Claimant[] getClaimants() {
        return this.claimants;
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public ClaimableBalanceEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setBalanceID(ClaimableBalanceID balanceID) {
        this.balanceID = balanceID;
    }

    @Generated
    public void setClaimants(Claimant[] claimants) {
        this.claimants = claimants;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public void setExt(ClaimableBalanceEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimableBalanceEntry)) {
            return false;
        }
        ClaimableBalanceEntry other = (ClaimableBalanceEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClaimableBalanceID this$balanceID = this.getBalanceID();
        ClaimableBalanceID other$balanceID = other.getBalanceID();
        if (this$balanceID == null ? other$balanceID != null : !((Object)this$balanceID).equals(other$balanceID)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getClaimants(), other.getClaimants())) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        ClaimableBalanceEntryExt this$ext = this.getExt();
        ClaimableBalanceEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimableBalanceEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClaimableBalanceID $balanceID = this.getBalanceID();
        result = result * 59 + ($balanceID == null ? 43 : ((Object)$balanceID).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getClaimants());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        ClaimableBalanceEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimableBalanceEntry(balanceID=" + this.getBalanceID() + ", claimants=" + Arrays.deepToString(this.getClaimants()) + ", asset=" + this.getAsset() + ", amount=" + this.getAmount() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public ClaimableBalanceEntry() {
    }

    @Generated
    public ClaimableBalanceEntry(ClaimableBalanceID balanceID, Claimant[] claimants, Asset asset, Int64 amount, ClaimableBalanceEntryExt ext) {
        this.balanceID = balanceID;
        this.claimants = claimants;
        this.asset = asset;
        this.amount = amount;
        this.ext = ext;
    }

    public static class ClaimableBalanceEntryExt
    implements XdrElement {
        private Integer discriminant;
        private ClaimableBalanceEntryExtensionV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static ClaimableBalanceEntryExt decode(XdrDataInputStream stream) throws IOException {
            ClaimableBalanceEntryExt decodedClaimableBalanceEntryExt = new ClaimableBalanceEntryExt();
            Integer discriminant = stream.readInt();
            decodedClaimableBalanceEntryExt.setDiscriminant(discriminant);
            switch (decodedClaimableBalanceEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedClaimableBalanceEntryExt.v1 = ClaimableBalanceEntryExtensionV1.decode(stream);
                }
            }
            return decodedClaimableBalanceEntryExt;
        }

        public static ClaimableBalanceEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ClaimableBalanceEntryExt.fromXdrByteArray(bytes);
        }

        public static ClaimableBalanceEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ClaimableBalanceEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static ClaimableBalanceEntryExtBuilder builder() {
            return new ClaimableBalanceEntryExtBuilder();
        }

        @Generated
        public ClaimableBalanceEntryExtBuilder toBuilder() {
            return new ClaimableBalanceEntryExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public ClaimableBalanceEntryExtensionV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(ClaimableBalanceEntryExtensionV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClaimableBalanceEntryExt)) {
                return false;
            }
            ClaimableBalanceEntryExt other = (ClaimableBalanceEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            ClaimableBalanceEntryExtensionV1 this$v1 = this.getV1();
            ClaimableBalanceEntryExtensionV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClaimableBalanceEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            ClaimableBalanceEntryExtensionV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClaimableBalanceEntry.ClaimableBalanceEntryExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public ClaimableBalanceEntryExt() {
        }

        @Generated
        public ClaimableBalanceEntryExt(Integer discriminant, ClaimableBalanceEntryExtensionV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class ClaimableBalanceEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private ClaimableBalanceEntryExtensionV1 v1;

            @Generated
            ClaimableBalanceEntryExtBuilder() {
            }

            @Generated
            public ClaimableBalanceEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public ClaimableBalanceEntryExtBuilder v1(ClaimableBalanceEntryExtensionV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public ClaimableBalanceEntryExt build() {
                return new ClaimableBalanceEntryExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "ClaimableBalanceEntry.ClaimableBalanceEntryExt.ClaimableBalanceEntryExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }

    @Generated
    public static class ClaimableBalanceEntryBuilder {
        @Generated
        private ClaimableBalanceID balanceID;
        @Generated
        private Claimant[] claimants;
        @Generated
        private Asset asset;
        @Generated
        private Int64 amount;
        @Generated
        private ClaimableBalanceEntryExt ext;

        @Generated
        ClaimableBalanceEntryBuilder() {
        }

        @Generated
        public ClaimableBalanceEntryBuilder balanceID(ClaimableBalanceID balanceID) {
            this.balanceID = balanceID;
            return this;
        }

        @Generated
        public ClaimableBalanceEntryBuilder claimants(Claimant[] claimants) {
            this.claimants = claimants;
            return this;
        }

        @Generated
        public ClaimableBalanceEntryBuilder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public ClaimableBalanceEntryBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public ClaimableBalanceEntryBuilder ext(ClaimableBalanceEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public ClaimableBalanceEntry build() {
            return new ClaimableBalanceEntry(this.balanceID, this.claimants, this.asset, this.amount, this.ext);
        }

        @Generated
        public String toString() {
            return "ClaimableBalanceEntry.ClaimableBalanceEntryBuilder(balanceID=" + this.balanceID + ", claimants=" + Arrays.deepToString(this.claimants) + ", asset=" + this.asset + ", amount=" + this.amount + ", ext=" + this.ext + ")";
        }
    }
}

