/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateClaimableBalanceOp
implements XdrElement {
    private Asset asset;
    private Int64 amount;
    private Claimant[] claimants;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.asset.encode(stream);
        this.amount.encode(stream);
        int claimantsSize = this.getClaimants().length;
        stream.writeInt(claimantsSize);
        for (int i = 0; i < claimantsSize; ++i) {
            this.claimants[i].encode(stream);
        }
    }

    public static CreateClaimableBalanceOp decode(XdrDataInputStream stream) throws IOException {
        CreateClaimableBalanceOp decodedCreateClaimableBalanceOp = new CreateClaimableBalanceOp();
        decodedCreateClaimableBalanceOp.asset = Asset.decode(stream);
        decodedCreateClaimableBalanceOp.amount = Int64.decode(stream);
        int claimantsSize = stream.readInt();
        decodedCreateClaimableBalanceOp.claimants = new Claimant[claimantsSize];
        for (int i = 0; i < claimantsSize; ++i) {
            decodedCreateClaimableBalanceOp.claimants[i] = Claimant.decode(stream);
        }
        return decodedCreateClaimableBalanceOp;
    }

    public static CreateClaimableBalanceOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateClaimableBalanceOp.fromXdrByteArray(bytes);
    }

    public static CreateClaimableBalanceOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateClaimableBalanceOp.decode(xdrDataInputStream);
    }

    @Generated
    public static CreateClaimableBalanceOpBuilder builder() {
        return new CreateClaimableBalanceOpBuilder();
    }

    @Generated
    public CreateClaimableBalanceOpBuilder toBuilder() {
        return new CreateClaimableBalanceOpBuilder().asset(this.asset).amount(this.amount).claimants(this.claimants);
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public Claimant[] getClaimants() {
        return this.claimants;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public void setClaimants(Claimant[] claimants) {
        this.claimants = claimants;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateClaimableBalanceOp)) {
            return false;
        }
        CreateClaimableBalanceOp other = (CreateClaimableBalanceOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        return Arrays.deepEquals(this.getClaimants(), other.getClaimants());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateClaimableBalanceOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getClaimants());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateClaimableBalanceOp(asset=" + this.getAsset() + ", amount=" + this.getAmount() + ", claimants=" + Arrays.deepToString(this.getClaimants()) + ")";
    }

    @Generated
    public CreateClaimableBalanceOp() {
    }

    @Generated
    public CreateClaimableBalanceOp(Asset asset, Int64 amount, Claimant[] claimants) {
        this.asset = asset;
        this.amount = amount;
        this.claimants = claimants;
    }

    @Generated
    public static class CreateClaimableBalanceOpBuilder {
        @Generated
        private Asset asset;
        @Generated
        private Int64 amount;
        @Generated
        private Claimant[] claimants;

        @Generated
        CreateClaimableBalanceOpBuilder() {
        }

        @Generated
        public CreateClaimableBalanceOpBuilder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public CreateClaimableBalanceOpBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public CreateClaimableBalanceOpBuilder claimants(Claimant[] claimants) {
            this.claimants = claimants;
            return this;
        }

        @Generated
        public CreateClaimableBalanceOp build() {
            return new CreateClaimableBalanceOp(this.asset, this.amount, this.claimants);
        }

        @Generated
        public String toString() {
            return "CreateClaimableBalanceOp.CreateClaimableBalanceOpBuilder(asset=" + this.asset + ", amount=" + this.amount + ", claimants=" + Arrays.deepToString(this.claimants) + ")";
        }
    }
}

