/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Int128Parts
implements XdrElement {
    private Int64 hi;
    private Uint64 lo;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.hi.encode(stream);
        this.lo.encode(stream);
    }

    public static Int128Parts decode(XdrDataInputStream stream) throws IOException {
        Int128Parts decodedInt128Parts = new Int128Parts();
        decodedInt128Parts.hi = Int64.decode(stream);
        decodedInt128Parts.lo = Uint64.decode(stream);
        return decodedInt128Parts;
    }

    public static Int128Parts fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Int128Parts.fromXdrByteArray(bytes);
    }

    public static Int128Parts fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Int128Parts.decode(xdrDataInputStream);
    }

    @Generated
    public static Int128PartsBuilder builder() {
        return new Int128PartsBuilder();
    }

    @Generated
    public Int128PartsBuilder toBuilder() {
        return new Int128PartsBuilder().hi(this.hi).lo(this.lo);
    }

    @Generated
    public Int64 getHi() {
        return this.hi;
    }

    @Generated
    public Uint64 getLo() {
        return this.lo;
    }

    @Generated
    public void setHi(Int64 hi) {
        this.hi = hi;
    }

    @Generated
    public void setLo(Uint64 lo) {
        this.lo = lo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Int128Parts)) {
            return false;
        }
        Int128Parts other = (Int128Parts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Int64 this$hi = this.getHi();
        Int64 other$hi = other.getHi();
        if (this$hi == null ? other$hi != null : !((Object)this$hi).equals(other$hi)) {
            return false;
        }
        Uint64 this$lo = this.getLo();
        Uint64 other$lo = other.getLo();
        return !(this$lo == null ? other$lo != null : !((Object)this$lo).equals(other$lo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Int128Parts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int64 $hi = this.getHi();
        result = result * 59 + ($hi == null ? 43 : ((Object)$hi).hashCode());
        Uint64 $lo = this.getLo();
        result = result * 59 + ($lo == null ? 43 : ((Object)$lo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Int128Parts(hi=" + this.getHi() + ", lo=" + this.getLo() + ")";
    }

    @Generated
    public Int128Parts() {
    }

    @Generated
    public Int128Parts(Int64 hi, Uint64 lo) {
        this.hi = hi;
        this.lo = lo;
    }

    @Generated
    public static class Int128PartsBuilder {
        @Generated
        private Int64 hi;
        @Generated
        private Uint64 lo;

        @Generated
        Int128PartsBuilder() {
        }

        @Generated
        public Int128PartsBuilder hi(Int64 hi) {
            this.hi = hi;
            return this;
        }

        @Generated
        public Int128PartsBuilder lo(Uint64 lo) {
            this.lo = lo;
            return this;
        }

        @Generated
        public Int128Parts build() {
            return new Int128Parts(this.hi, this.lo);
        }

        @Generated
        public String toString() {
            return "Int128Parts.Int128PartsBuilder(hi=" + this.hi + ", lo=" + this.lo + ")";
        }
    }
}

