/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCMetaKind;
import org.stellar.sdk.xdr.SCMetaV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCMetaEntry
implements XdrElement {
    private SCMetaKind discriminant;
    private SCMetaV0 v0;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SC_META_V0: {
                this.v0.encode(stream);
            }
        }
    }

    public static SCMetaEntry decode(XdrDataInputStream stream) throws IOException {
        SCMetaEntry decodedSCMetaEntry = new SCMetaEntry();
        SCMetaKind discriminant = SCMetaKind.decode(stream);
        decodedSCMetaEntry.setDiscriminant(discriminant);
        switch (decodedSCMetaEntry.getDiscriminant()) {
            case SC_META_V0: {
                decodedSCMetaEntry.v0 = SCMetaV0.decode(stream);
            }
        }
        return decodedSCMetaEntry;
    }

    public static SCMetaEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCMetaEntry.fromXdrByteArray(bytes);
    }

    public static SCMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCMetaEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static SCMetaEntryBuilder builder() {
        return new SCMetaEntryBuilder();
    }

    @Generated
    public SCMetaEntryBuilder toBuilder() {
        return new SCMetaEntryBuilder().discriminant(this.discriminant).v0(this.v0);
    }

    @Generated
    public SCMetaKind getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public SCMetaV0 getV0() {
        return this.v0;
    }

    @Generated
    public void setDiscriminant(SCMetaKind discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(SCMetaV0 v0) {
        this.v0 = v0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCMetaEntry)) {
            return false;
        }
        SCMetaEntry other = (SCMetaEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCMetaKind this$discriminant = this.getDiscriminant();
        SCMetaKind other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        SCMetaV0 this$v0 = this.getV0();
        SCMetaV0 other$v0 = other.getV0();
        return !(this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCMetaEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCMetaKind $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        SCMetaV0 $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCMetaEntry(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ")";
    }

    @Generated
    public SCMetaEntry() {
    }

    @Generated
    public SCMetaEntry(SCMetaKind discriminant, SCMetaV0 v0) {
        this.discriminant = discriminant;
        this.v0 = v0;
    }

    @Generated
    public static class SCMetaEntryBuilder {
        @Generated
        private SCMetaKind discriminant;
        @Generated
        private SCMetaV0 v0;

        @Generated
        SCMetaEntryBuilder() {
        }

        @Generated
        public SCMetaEntryBuilder discriminant(SCMetaKind discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCMetaEntryBuilder v0(SCMetaV0 v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public SCMetaEntry build() {
            return new SCMetaEntry(this.discriminant, this.v0);
        }

        @Generated
        public String toString() {
            return "SCMetaEntry.SCMetaEntryBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ")";
        }
    }
}

