/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Value;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPBallot
implements XdrElement {
    private Uint32 counter;
    private Value value;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.counter.encode(stream);
        this.value.encode(stream);
    }

    public static SCPBallot decode(XdrDataInputStream stream) throws IOException {
        SCPBallot decodedSCPBallot = new SCPBallot();
        decodedSCPBallot.counter = Uint32.decode(stream);
        decodedSCPBallot.value = Value.decode(stream);
        return decodedSCPBallot;
    }

    public static SCPBallot fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPBallot.fromXdrByteArray(bytes);
    }

    public static SCPBallot fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPBallot.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPBallotBuilder builder() {
        return new SCPBallotBuilder();
    }

    @Generated
    public SCPBallotBuilder toBuilder() {
        return new SCPBallotBuilder().counter(this.counter).value(this.value);
    }

    @Generated
    public Uint32 getCounter() {
        return this.counter;
    }

    @Generated
    public Value getValue() {
        return this.value;
    }

    @Generated
    public void setCounter(Uint32 counter) {
        this.counter = counter;
    }

    @Generated
    public void setValue(Value value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPBallot)) {
            return false;
        }
        SCPBallot other = (SCPBallot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$counter = this.getCounter();
        Uint32 other$counter = other.getCounter();
        if (this$counter == null ? other$counter != null : !((Object)this$counter).equals(other$counter)) {
            return false;
        }
        Value this$value = this.getValue();
        Value other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPBallot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : ((Object)$counter).hashCode());
        Value $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPBallot(counter=" + this.getCounter() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public SCPBallot() {
    }

    @Generated
    public SCPBallot(Uint32 counter, Value value) {
        this.counter = counter;
        this.value = value;
    }

    @Generated
    public static class SCPBallotBuilder {
        @Generated
        private Uint32 counter;
        @Generated
        private Value value;

        @Generated
        SCPBallotBuilder() {
        }

        @Generated
        public SCPBallotBuilder counter(Uint32 counter) {
            this.counter = counter;
            return this;
        }

        @Generated
        public SCPBallotBuilder value(Value value) {
            this.value = value;
            return this;
        }

        @Generated
        public SCPBallot build() {
            return new SCPBallot(this.counter, this.value);
        }

        @Generated
        public String toString() {
            return "SCPBallot.SCPBallotBuilder(counter=" + this.counter + ", value=" + this.value + ")";
        }
    }
}

