/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionV0Envelope
implements XdrElement {
    private TransactionV0 tx;
    private DecoratedSignature[] signatures;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.tx.encode(stream);
        int signaturesSize = this.getSignatures().length;
        stream.writeInt(signaturesSize);
        for (int i = 0; i < signaturesSize; ++i) {
            this.signatures[i].encode(stream);
        }
    }

    public static TransactionV0Envelope decode(XdrDataInputStream stream) throws IOException {
        TransactionV0Envelope decodedTransactionV0Envelope = new TransactionV0Envelope();
        decodedTransactionV0Envelope.tx = TransactionV0.decode(stream);
        int signaturesSize = stream.readInt();
        decodedTransactionV0Envelope.signatures = new DecoratedSignature[signaturesSize];
        for (int i = 0; i < signaturesSize; ++i) {
            decodedTransactionV0Envelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedTransactionV0Envelope;
    }

    public static TransactionV0Envelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionV0Envelope.fromXdrByteArray(bytes);
    }

    public static TransactionV0Envelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionV0Envelope.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionV0EnvelopeBuilder builder() {
        return new TransactionV0EnvelopeBuilder();
    }

    @Generated
    public TransactionV0EnvelopeBuilder toBuilder() {
        return new TransactionV0EnvelopeBuilder().tx(this.tx).signatures(this.signatures);
    }

    @Generated
    public TransactionV0 getTx() {
        return this.tx;
    }

    @Generated
    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    @Generated
    public void setTx(TransactionV0 tx) {
        this.tx = tx;
    }

    @Generated
    public void setSignatures(DecoratedSignature[] signatures) {
        this.signatures = signatures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionV0Envelope)) {
            return false;
        }
        TransactionV0Envelope other = (TransactionV0Envelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionV0 this$tx = this.getTx();
        TransactionV0 other$tx = other.getTx();
        if (this$tx == null ? other$tx != null : !((Object)this$tx).equals(other$tx)) {
            return false;
        }
        return Arrays.deepEquals(this.getSignatures(), other.getSignatures());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionV0Envelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionV0 $tx = this.getTx();
        result = result * 59 + ($tx == null ? 43 : ((Object)$tx).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSignatures());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionV0Envelope(tx=" + this.getTx() + ", signatures=" + Arrays.deepToString(this.getSignatures()) + ")";
    }

    @Generated
    public TransactionV0Envelope() {
    }

    @Generated
    public TransactionV0Envelope(TransactionV0 tx, DecoratedSignature[] signatures) {
        this.tx = tx;
        this.signatures = signatures;
    }

    @Generated
    public static class TransactionV0EnvelopeBuilder {
        @Generated
        private TransactionV0 tx;
        @Generated
        private DecoratedSignature[] signatures;

        @Generated
        TransactionV0EnvelopeBuilder() {
        }

        @Generated
        public TransactionV0EnvelopeBuilder tx(TransactionV0 tx) {
            this.tx = tx;
            return this;
        }

        @Generated
        public TransactionV0EnvelopeBuilder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        @Generated
        public TransactionV0Envelope build() {
            return new TransactionV0Envelope(this.tx, this.signatures);
        }

        @Generated
        public String toString() {
            return "TransactionV0Envelope.TransactionV0EnvelopeBuilder(tx=" + this.tx + ", signatures=" + Arrays.deepToString(this.signatures) + ")";
        }
    }
}

