/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;

public class PathPaymentStrictSendOperation
extends Operation {
    @NonNull
    private final Asset sendAsset;
    @NonNull
    private final BigDecimal sendAmount;
    @NonNull
    private final String destination;
    @NonNull
    private final Asset destAsset;
    @NonNull
    private final BigDecimal destMin;
    @NonNull
    private final Asset[] path;

    public static PathPaymentStrictSendOperation fromXdr(PathPaymentStrictSendOp op) {
        Asset sendAsset = Asset.fromXdr(op.getSendAsset());
        BigDecimal sendAmount = Operation.fromXdrAmount(op.getSendAmount().getInt64());
        String destination = StrKey.encodeMuxedAccount(op.getDestination());
        Asset destAsset = Asset.fromXdr(op.getDestAsset());
        BigDecimal destMin = Operation.fromXdrAmount(op.getDestMin().getInt64());
        Asset[] path = new Asset[op.getPath().length];
        for (int i = 0; i < op.getPath().length; ++i) {
            path[i] = Asset.fromXdr(op.getPath()[i]);
        }
        return new PathPaymentStrictSendOperation(sendAsset, sendAmount, destination, destAsset, destMin, path);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        PathPaymentStrictSendOp op = new PathPaymentStrictSendOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendAmount = new Int64();
        sendAmount.setInt64(Operation.toXdrAmount(this.sendAmount));
        op.setSendAmount(sendAmount);
        op.setDestination(StrKey.encodeToXDRMuxedAccount(this.destination));
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destMin = new Int64();
        destMin.setInt64(Operation.toXdrAmount(this.destMin));
        op.setDestMin(destMin);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_SEND);
        body.setPathPaymentStrictSendOp(op);
        return body;
    }

    @Generated
    private static Asset[] $default$path() {
        return new Asset[0];
    }

    @Generated
    protected PathPaymentStrictSendOperation(PathPaymentStrictSendOperationBuilder<?, ?> b) {
        super(b);
        this.sendAsset = ((PathPaymentStrictSendOperationBuilder)b).sendAsset;
        if (this.sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        this.sendAmount = ((PathPaymentStrictSendOperationBuilder)b).sendAmount;
        if (this.sendAmount == null) {
            throw new NullPointerException("sendAmount is marked non-null but is null");
        }
        this.destination = ((PathPaymentStrictSendOperationBuilder)b).destination;
        if (this.destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destAsset = ((PathPaymentStrictSendOperationBuilder)b).destAsset;
        if (this.destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        this.destMin = ((PathPaymentStrictSendOperationBuilder)b).destMin;
        if (this.destMin == null) {
            throw new NullPointerException("destMin is marked non-null but is null");
        }
        this.path = ((PathPaymentStrictSendOperationBuilder)b).path$set ? ((PathPaymentStrictSendOperationBuilder)b).path$value : PathPaymentStrictSendOperation.$default$path();
        if (this.path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    @Generated
    public static PathPaymentStrictSendOperationBuilder<?, ?> builder() {
        return new PathPaymentStrictSendOperationBuilderImpl();
    }

    @Generated
    public PathPaymentStrictSendOperationBuilder<?, ?> toBuilder() {
        return new PathPaymentStrictSendOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @NonNull
    @Generated
    public BigDecimal getSendAmount() {
        return this.sendAmount;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @NonNull
    @Generated
    public BigDecimal getDestMin() {
        return this.destMin;
    }

    @NonNull
    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictSendOperation(super=" + super.toString() + ", sendAsset=" + this.getSendAsset() + ", sendAmount=" + this.getSendAmount() + ", destination=" + this.getDestination() + ", destAsset=" + this.getDestAsset() + ", destMin=" + this.getDestMin() + ", path=" + Arrays.deepToString(this.getPath()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictSendOperation)) {
            return false;
        }
        PathPaymentStrictSendOperation other = (PathPaymentStrictSendOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        BigDecimal this$sendAmount = this.getSendAmount();
        BigDecimal other$sendAmount = other.getSendAmount();
        if (this$sendAmount == null ? other$sendAmount != null : !((Object)this$sendAmount).equals(other$sendAmount)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        BigDecimal this$destMin = this.getDestMin();
        BigDecimal other$destMin = other.getDestMin();
        if (this$destMin == null ? other$destMin != null : !((Object)this$destMin).equals(other$destMin)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictSendOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : $sendAsset.hashCode());
        BigDecimal $sendAmount = this.getSendAmount();
        result = result * 59 + ($sendAmount == null ? 43 : ((Object)$sendAmount).hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : $destAsset.hashCode());
        BigDecimal $destMin = this.getDestMin();
        result = result * 59 + ($destMin == null ? 43 : ((Object)$destMin).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    @Generated
    private PathPaymentStrictSendOperation(@NonNull Asset sendAsset, @NonNull BigDecimal sendAmount, @NonNull String destination, @NonNull Asset destAsset, @NonNull BigDecimal destMin, @NonNull Asset[] path) {
        if (sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        if (sendAmount == null) {
            throw new NullPointerException("sendAmount is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        if (destMin == null) {
            throw new NullPointerException("destMin is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.sendAsset = sendAsset;
        this.sendAmount = sendAmount;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destMin = destMin;
        this.path = path;
    }

    public static abstract class PathPaymentStrictSendOperationBuilder<C extends PathPaymentStrictSendOperation, B extends PathPaymentStrictSendOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private Asset sendAsset;
        @Generated
        private BigDecimal sendAmount;
        @Generated
        private String destination;
        @Generated
        private Asset destAsset;
        @Generated
        private BigDecimal destMin;
        @Generated
        private boolean path$set;
        @Generated
        private Asset[] path$value;

        public B sendAmount(@NonNull BigDecimal sendAmount) {
            if (sendAmount == null) {
                throw new NullPointerException("sendAmount is marked non-null but is null");
            }
            this.sendAmount = Operation.formatAmountScale(sendAmount);
            return (B)this.self();
        }

        public B destMin(@NonNull BigDecimal destMin) {
            if (destMin == null) {
                throw new NullPointerException("destMin is marked non-null but is null");
            }
            this.destMin = Operation.formatAmountScale(destMin);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PathPaymentStrictSendOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PathPaymentStrictSendOperation instance, PathPaymentStrictSendOperationBuilder<?, ?> b) {
            b.sendAsset(instance.sendAsset);
            b.sendAmount(instance.sendAmount);
            b.destination(instance.destination);
            b.destAsset(instance.destAsset);
            b.destMin(instance.destMin);
            b.path(instance.path);
        }

        @Generated
        public B sendAsset(@NonNull Asset sendAsset) {
            if (sendAsset == null) {
                throw new NullPointerException("sendAsset is marked non-null but is null");
            }
            this.sendAsset = sendAsset;
            return (B)this.self();
        }

        @Generated
        public B destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return (B)this.self();
        }

        @Generated
        public B destAsset(@NonNull Asset destAsset) {
            if (destAsset == null) {
                throw new NullPointerException("destAsset is marked non-null but is null");
            }
            this.destAsset = destAsset;
            return (B)this.self();
        }

        @Generated
        public B path(@NonNull Asset[] path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path$value = path;
            this.path$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PathPaymentStrictSendOperation.PathPaymentStrictSendOperationBuilder(super=" + super.toString() + ", sendAsset=" + this.sendAsset + ", sendAmount=" + this.sendAmount + ", destination=" + this.destination + ", destAsset=" + this.destAsset + ", destMin=" + this.destMin + ", path$value=" + Arrays.deepToString(this.path$value) + ")";
        }
    }

    @Generated
    private static final class PathPaymentStrictSendOperationBuilderImpl
    extends PathPaymentStrictSendOperationBuilder<PathPaymentStrictSendOperation, PathPaymentStrictSendOperationBuilderImpl> {
        @Generated
        private PathPaymentStrictSendOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected PathPaymentStrictSendOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PathPaymentStrictSendOperation build() {
            return new PathPaymentStrictSendOperation(this);
        }
    }
}

