/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.sorobanrpc;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.requests.sorobanrpc.EventFilterType;
import org.stellar.sdk.xdr.SCVal;

public final class GetEventsResponse {
    private final List<EventInfo> events;
    private final Long latestLedger;
    private final String cursor;

    @Generated
    public GetEventsResponse(List<EventInfo> events, Long latestLedger, String cursor) {
        this.events = events;
        this.latestLedger = latestLedger;
        this.cursor = cursor;
    }

    @Generated
    public List<EventInfo> getEvents() {
        return this.events;
    }

    @Generated
    public Long getLatestLedger() {
        return this.latestLedger;
    }

    @Generated
    public String getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEventsResponse)) {
            return false;
        }
        GetEventsResponse other = (GetEventsResponse)o;
        Long this$latestLedger = this.getLatestLedger();
        Long other$latestLedger = other.getLatestLedger();
        if (this$latestLedger == null ? other$latestLedger != null : !((Object)this$latestLedger).equals(other$latestLedger)) {
            return false;
        }
        List<EventInfo> this$events = this.getEvents();
        List<EventInfo> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $latestLedger = this.getLatestLedger();
        result = result * 59 + ($latestLedger == null ? 43 : ((Object)$latestLedger).hashCode());
        List<EventInfo> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetEventsResponse(events=" + this.getEvents() + ", latestLedger=" + this.getLatestLedger() + ", cursor=" + this.getCursor() + ")";
    }

    public static final class EventInfo {
        private final EventFilterType type;
        private final Long ledger;
        private final String ledgerClosedAt;
        private final String contractId;
        private final String id;
        private final String pagingToken;
        private final List<String> topic;
        private final String value;
        private final Boolean inSuccessfulContractCall;
        @SerializedName(value="txHash")
        private final String transactionHash;

        public List<SCVal> parseTopic() {
            if (this.topic == null) {
                return null;
            }
            return this.topic.stream().map(t -> Util.parseXdr(t, SCVal::fromXdrBase64)).collect(Collectors.toList());
        }

        public SCVal parseValue() {
            return Util.parseXdr(this.value, SCVal::fromXdrBase64);
        }

        @Generated
        public EventInfo(EventFilterType type, Long ledger, String ledgerClosedAt, String contractId, String id, String pagingToken, List<String> topic, String value, Boolean inSuccessfulContractCall, String transactionHash) {
            this.type = type;
            this.ledger = ledger;
            this.ledgerClosedAt = ledgerClosedAt;
            this.contractId = contractId;
            this.id = id;
            this.pagingToken = pagingToken;
            this.topic = topic;
            this.value = value;
            this.inSuccessfulContractCall = inSuccessfulContractCall;
            this.transactionHash = transactionHash;
        }

        @Generated
        public EventFilterType getType() {
            return this.type;
        }

        @Generated
        public Long getLedger() {
            return this.ledger;
        }

        @Generated
        public String getLedgerClosedAt() {
            return this.ledgerClosedAt;
        }

        @Generated
        public String getContractId() {
            return this.contractId;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPagingToken() {
            return this.pagingToken;
        }

        @Generated
        public List<String> getTopic() {
            return this.topic;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Boolean getInSuccessfulContractCall() {
            return this.inSuccessfulContractCall;
        }

        @Generated
        public String getTransactionHash() {
            return this.transactionHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventInfo)) {
                return false;
            }
            EventInfo other = (EventInfo)o;
            Long this$ledger = this.getLedger();
            Long other$ledger = other.getLedger();
            if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
                return false;
            }
            Boolean this$inSuccessfulContractCall = this.getInSuccessfulContractCall();
            Boolean other$inSuccessfulContractCall = other.getInSuccessfulContractCall();
            if (this$inSuccessfulContractCall == null ? other$inSuccessfulContractCall != null : !((Object)this$inSuccessfulContractCall).equals(other$inSuccessfulContractCall)) {
                return false;
            }
            EventFilterType this$type = this.getType();
            EventFilterType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$ledgerClosedAt = this.getLedgerClosedAt();
            String other$ledgerClosedAt = other.getLedgerClosedAt();
            if (this$ledgerClosedAt == null ? other$ledgerClosedAt != null : !this$ledgerClosedAt.equals(other$ledgerClosedAt)) {
                return false;
            }
            String this$contractId = this.getContractId();
            String other$contractId = other.getContractId();
            if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$pagingToken = this.getPagingToken();
            String other$pagingToken = other.getPagingToken();
            if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
                return false;
            }
            List<String> this$topic = this.getTopic();
            List<String> other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$transactionHash = this.getTransactionHash();
            String other$transactionHash = other.getTransactionHash();
            return !(this$transactionHash == null ? other$transactionHash != null : !this$transactionHash.equals(other$transactionHash));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $ledger = this.getLedger();
            result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
            Boolean $inSuccessfulContractCall = this.getInSuccessfulContractCall();
            result = result * 59 + ($inSuccessfulContractCall == null ? 43 : ((Object)$inSuccessfulContractCall).hashCode());
            EventFilterType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $ledgerClosedAt = this.getLedgerClosedAt();
            result = result * 59 + ($ledgerClosedAt == null ? 43 : $ledgerClosedAt.hashCode());
            String $contractId = this.getContractId();
            result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $pagingToken = this.getPagingToken();
            result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
            List<String> $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $transactionHash = this.getTransactionHash();
            result = result * 59 + ($transactionHash == null ? 43 : $transactionHash.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetEventsResponse.EventInfo(type=" + (Object)((Object)this.getType()) + ", ledger=" + this.getLedger() + ", ledgerClosedAt=" + this.getLedgerClosedAt() + ", contractId=" + this.getContractId() + ", id=" + this.getId() + ", pagingToken=" + this.getPagingToken() + ", topic=" + this.getTopic() + ", value=" + this.getValue() + ", inSuccessfulContractCall=" + this.getInSuccessfulContractCall() + ", transactionHash=" + this.getTransactionHash() + ")";
        }
    }
}

