/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractCodeCostInputs;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractCodeEntry
implements XdrElement {
    private ContractCodeEntryExt ext;
    private Hash hash;
    private byte[] code;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.hash.encode(stream);
        int codeSize = this.code.length;
        stream.writeInt(codeSize);
        stream.write(this.getCode(), 0, codeSize);
    }

    public static ContractCodeEntry decode(XdrDataInputStream stream) throws IOException {
        ContractCodeEntry decodedContractCodeEntry = new ContractCodeEntry();
        decodedContractCodeEntry.ext = ContractCodeEntryExt.decode(stream);
        decodedContractCodeEntry.hash = Hash.decode(stream);
        int codeSize = stream.readInt();
        decodedContractCodeEntry.code = new byte[codeSize];
        stream.read(decodedContractCodeEntry.code, 0, codeSize);
        return decodedContractCodeEntry;
    }

    public static ContractCodeEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCodeEntry.fromXdrByteArray(bytes);
    }

    public static ContractCodeEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCodeEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static ContractCodeEntryBuilder builder() {
        return new ContractCodeEntryBuilder();
    }

    @Generated
    public ContractCodeEntryBuilder toBuilder() {
        return new ContractCodeEntryBuilder().ext(this.ext).hash(this.hash).code(this.code);
    }

    @Generated
    public ContractCodeEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public byte[] getCode() {
        return this.code;
    }

    @Generated
    public void setExt(ContractCodeEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public void setCode(byte[] code) {
        this.code = code;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractCodeEntry)) {
            return false;
        }
        ContractCodeEntry other = (ContractCodeEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractCodeEntryExt this$ext = this.getExt();
        ContractCodeEntryExt other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        return Arrays.equals(this.getCode(), other.getCode());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContractCodeEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractCodeEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractCodeEntry(ext=" + this.getExt() + ", hash=" + this.getHash() + ", code=" + Arrays.toString(this.getCode()) + ")";
    }

    @Generated
    public ContractCodeEntry() {
    }

    @Generated
    public ContractCodeEntry(ContractCodeEntryExt ext, Hash hash, byte[] code) {
        this.ext = ext;
        this.hash = hash;
        this.code = code;
    }

    public static class ContractCodeEntryExt
    implements XdrElement {
        private Integer discriminant;
        private ContractCodeEntryV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static ContractCodeEntryExt decode(XdrDataInputStream stream) throws IOException {
            ContractCodeEntryExt decodedContractCodeEntryExt = new ContractCodeEntryExt();
            Integer discriminant = stream.readInt();
            decodedContractCodeEntryExt.setDiscriminant(discriminant);
            switch (decodedContractCodeEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedContractCodeEntryExt.v1 = ContractCodeEntryV1.decode(stream);
                }
            }
            return decodedContractCodeEntryExt;
        }

        public static ContractCodeEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ContractCodeEntryExt.fromXdrByteArray(bytes);
        }

        public static ContractCodeEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ContractCodeEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static ContractCodeEntryExtBuilder builder() {
            return new ContractCodeEntryExtBuilder();
        }

        @Generated
        public ContractCodeEntryExtBuilder toBuilder() {
            return new ContractCodeEntryExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public ContractCodeEntryV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(ContractCodeEntryV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractCodeEntryExt)) {
                return false;
            }
            ContractCodeEntryExt other = (ContractCodeEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            ContractCodeEntryV1 this$v1 = this.getV1();
            ContractCodeEntryV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContractCodeEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            ContractCodeEntryV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContractCodeEntry.ContractCodeEntryExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public ContractCodeEntryExt() {
        }

        @Generated
        public ContractCodeEntryExt(Integer discriminant, ContractCodeEntryV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        public static class ContractCodeEntryV1
        implements XdrElement {
            private ExtensionPoint ext;
            private ContractCodeCostInputs costInputs;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.ext.encode(stream);
                this.costInputs.encode(stream);
            }

            public static ContractCodeEntryV1 decode(XdrDataInputStream stream) throws IOException {
                ContractCodeEntryV1 decodedContractCodeEntryV1 = new ContractCodeEntryV1();
                decodedContractCodeEntryV1.ext = ExtensionPoint.decode(stream);
                decodedContractCodeEntryV1.costInputs = ContractCodeCostInputs.decode(stream);
                return decodedContractCodeEntryV1;
            }

            public static ContractCodeEntryV1 fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return ContractCodeEntryV1.fromXdrByteArray(bytes);
            }

            public static ContractCodeEntryV1 fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return ContractCodeEntryV1.decode(xdrDataInputStream);
            }

            @Generated
            public static ContractCodeEntryV1Builder builder() {
                return new ContractCodeEntryV1Builder();
            }

            @Generated
            public ContractCodeEntryV1Builder toBuilder() {
                return new ContractCodeEntryV1Builder().ext(this.ext).costInputs(this.costInputs);
            }

            @Generated
            public ExtensionPoint getExt() {
                return this.ext;
            }

            @Generated
            public ContractCodeCostInputs getCostInputs() {
                return this.costInputs;
            }

            @Generated
            public void setExt(ExtensionPoint ext) {
                this.ext = ext;
            }

            @Generated
            public void setCostInputs(ContractCodeCostInputs costInputs) {
                this.costInputs = costInputs;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContractCodeEntryV1)) {
                    return false;
                }
                ContractCodeEntryV1 other = (ContractCodeEntryV1)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ExtensionPoint this$ext = this.getExt();
                ExtensionPoint other$ext = other.getExt();
                if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
                    return false;
                }
                ContractCodeCostInputs this$costInputs = this.getCostInputs();
                ContractCodeCostInputs other$costInputs = other.getCostInputs();
                return !(this$costInputs == null ? other$costInputs != null : !((Object)this$costInputs).equals(other$costInputs));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ContractCodeEntryV1;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ExtensionPoint $ext = this.getExt();
                result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
                ContractCodeCostInputs $costInputs = this.getCostInputs();
                result = result * 59 + ($costInputs == null ? 43 : ((Object)$costInputs).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ContractCodeEntry.ContractCodeEntryExt.ContractCodeEntryV1(ext=" + this.getExt() + ", costInputs=" + this.getCostInputs() + ")";
            }

            @Generated
            public ContractCodeEntryV1() {
            }

            @Generated
            public ContractCodeEntryV1(ExtensionPoint ext, ContractCodeCostInputs costInputs) {
                this.ext = ext;
                this.costInputs = costInputs;
            }

            @Generated
            public static class ContractCodeEntryV1Builder {
                @Generated
                private ExtensionPoint ext;
                @Generated
                private ContractCodeCostInputs costInputs;

                @Generated
                ContractCodeEntryV1Builder() {
                }

                @Generated
                public ContractCodeEntryV1Builder ext(ExtensionPoint ext) {
                    this.ext = ext;
                    return this;
                }

                @Generated
                public ContractCodeEntryV1Builder costInputs(ContractCodeCostInputs costInputs) {
                    this.costInputs = costInputs;
                    return this;
                }

                @Generated
                public ContractCodeEntryV1 build() {
                    return new ContractCodeEntryV1(this.ext, this.costInputs);
                }

                @Generated
                public String toString() {
                    return "ContractCodeEntry.ContractCodeEntryExt.ContractCodeEntryV1.ContractCodeEntryV1Builder(ext=" + this.ext + ", costInputs=" + this.costInputs + ")";
                }
            }
        }

        @Generated
        public static class ContractCodeEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private ContractCodeEntryV1 v1;

            @Generated
            ContractCodeEntryExtBuilder() {
            }

            @Generated
            public ContractCodeEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public ContractCodeEntryExtBuilder v1(ContractCodeEntryV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public ContractCodeEntryExt build() {
                return new ContractCodeEntryExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "ContractCodeEntry.ContractCodeEntryExt.ContractCodeEntryExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }

    @Generated
    public static class ContractCodeEntryBuilder {
        @Generated
        private ContractCodeEntryExt ext;
        @Generated
        private Hash hash;
        @Generated
        private byte[] code;

        @Generated
        ContractCodeEntryBuilder() {
        }

        @Generated
        public ContractCodeEntryBuilder ext(ContractCodeEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public ContractCodeEntryBuilder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        @Generated
        public ContractCodeEntryBuilder code(byte[] code) {
            this.code = code;
            return this;
        }

        @Generated
        public ContractCodeEntry build() {
            return new ContractCodeEntry(this.ext, this.hash, this.code);
        }

        @Generated
        public String toString() {
            return "ContractCodeEntry.ContractCodeEntryBuilder(ext=" + this.ext + ", hash=" + this.hash + ", code=" + Arrays.toString(this.code) + ")";
        }
    }
}

