/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LiquidityPoolWithdrawResultCode implements XdrElement
{
    LIQUIDITY_POOL_WITHDRAW_SUCCESS(0),
    LIQUIDITY_POOL_WITHDRAW_MALFORMED(-1),
    LIQUIDITY_POOL_WITHDRAW_NO_TRUST(-2),
    LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED(-3),
    LIQUIDITY_POOL_WITHDRAW_LINE_FULL(-4),
    LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM(-5);

    private final int value;

    private LiquidityPoolWithdrawResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LiquidityPoolWithdrawResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LIQUIDITY_POOL_WITHDRAW_SUCCESS;
            }
            case -1: {
                return LIQUIDITY_POOL_WITHDRAW_MALFORMED;
            }
            case -2: {
                return LIQUIDITY_POOL_WITHDRAW_NO_TRUST;
            }
            case -3: {
                return LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED;
            }
            case -4: {
                return LIQUIDITY_POOL_WITHDRAW_LINE_FULL;
            }
            case -5: {
                return LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static LiquidityPoolWithdrawResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolWithdrawResultCode.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolWithdrawResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolWithdrawResultCode.decode(xdrDataInputStream);
    }
}

