/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeSlicedNodeData
implements XdrElement {
    private Uint32 addedAuthenticatedPeers;
    private Uint32 droppedAuthenticatedPeers;
    private Uint32 totalInboundPeerCount;
    private Uint32 totalOutboundPeerCount;
    private Uint32 p75SCPFirstToSelfLatencyMs;
    private Uint32 p75SCPSelfToOtherLatencyMs;
    private Uint32 lostSyncCount;
    private Boolean isValidator;
    private Uint32 maxInboundPeerCount;
    private Uint32 maxOutboundPeerCount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.addedAuthenticatedPeers.encode(stream);
        this.droppedAuthenticatedPeers.encode(stream);
        this.totalInboundPeerCount.encode(stream);
        this.totalOutboundPeerCount.encode(stream);
        this.p75SCPFirstToSelfLatencyMs.encode(stream);
        this.p75SCPSelfToOtherLatencyMs.encode(stream);
        this.lostSyncCount.encode(stream);
        stream.writeInt(this.isValidator != false ? 1 : 0);
        this.maxInboundPeerCount.encode(stream);
        this.maxOutboundPeerCount.encode(stream);
    }

    public static TimeSlicedNodeData decode(XdrDataInputStream stream) throws IOException {
        TimeSlicedNodeData decodedTimeSlicedNodeData = new TimeSlicedNodeData();
        decodedTimeSlicedNodeData.addedAuthenticatedPeers = Uint32.decode(stream);
        decodedTimeSlicedNodeData.droppedAuthenticatedPeers = Uint32.decode(stream);
        decodedTimeSlicedNodeData.totalInboundPeerCount = Uint32.decode(stream);
        decodedTimeSlicedNodeData.totalOutboundPeerCount = Uint32.decode(stream);
        decodedTimeSlicedNodeData.p75SCPFirstToSelfLatencyMs = Uint32.decode(stream);
        decodedTimeSlicedNodeData.p75SCPSelfToOtherLatencyMs = Uint32.decode(stream);
        decodedTimeSlicedNodeData.lostSyncCount = Uint32.decode(stream);
        decodedTimeSlicedNodeData.isValidator = stream.readInt() == 1;
        decodedTimeSlicedNodeData.maxInboundPeerCount = Uint32.decode(stream);
        decodedTimeSlicedNodeData.maxOutboundPeerCount = Uint32.decode(stream);
        return decodedTimeSlicedNodeData;
    }

    public static TimeSlicedNodeData fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeSlicedNodeData.fromXdrByteArray(bytes);
    }

    public static TimeSlicedNodeData fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeSlicedNodeData.decode(xdrDataInputStream);
    }

    @Generated
    public static TimeSlicedNodeDataBuilder builder() {
        return new TimeSlicedNodeDataBuilder();
    }

    @Generated
    public TimeSlicedNodeDataBuilder toBuilder() {
        return new TimeSlicedNodeDataBuilder().addedAuthenticatedPeers(this.addedAuthenticatedPeers).droppedAuthenticatedPeers(this.droppedAuthenticatedPeers).totalInboundPeerCount(this.totalInboundPeerCount).totalOutboundPeerCount(this.totalOutboundPeerCount).p75SCPFirstToSelfLatencyMs(this.p75SCPFirstToSelfLatencyMs).p75SCPSelfToOtherLatencyMs(this.p75SCPSelfToOtherLatencyMs).lostSyncCount(this.lostSyncCount).isValidator(this.isValidator).maxInboundPeerCount(this.maxInboundPeerCount).maxOutboundPeerCount(this.maxOutboundPeerCount);
    }

    @Generated
    public Uint32 getAddedAuthenticatedPeers() {
        return this.addedAuthenticatedPeers;
    }

    @Generated
    public Uint32 getDroppedAuthenticatedPeers() {
        return this.droppedAuthenticatedPeers;
    }

    @Generated
    public Uint32 getTotalInboundPeerCount() {
        return this.totalInboundPeerCount;
    }

    @Generated
    public Uint32 getTotalOutboundPeerCount() {
        return this.totalOutboundPeerCount;
    }

    @Generated
    public Uint32 getP75SCPFirstToSelfLatencyMs() {
        return this.p75SCPFirstToSelfLatencyMs;
    }

    @Generated
    public Uint32 getP75SCPSelfToOtherLatencyMs() {
        return this.p75SCPSelfToOtherLatencyMs;
    }

    @Generated
    public Uint32 getLostSyncCount() {
        return this.lostSyncCount;
    }

    @Generated
    public Boolean getIsValidator() {
        return this.isValidator;
    }

    @Generated
    public Uint32 getMaxInboundPeerCount() {
        return this.maxInboundPeerCount;
    }

    @Generated
    public Uint32 getMaxOutboundPeerCount() {
        return this.maxOutboundPeerCount;
    }

    @Generated
    public void setAddedAuthenticatedPeers(Uint32 addedAuthenticatedPeers) {
        this.addedAuthenticatedPeers = addedAuthenticatedPeers;
    }

    @Generated
    public void setDroppedAuthenticatedPeers(Uint32 droppedAuthenticatedPeers) {
        this.droppedAuthenticatedPeers = droppedAuthenticatedPeers;
    }

    @Generated
    public void setTotalInboundPeerCount(Uint32 totalInboundPeerCount) {
        this.totalInboundPeerCount = totalInboundPeerCount;
    }

    @Generated
    public void setTotalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
        this.totalOutboundPeerCount = totalOutboundPeerCount;
    }

    @Generated
    public void setP75SCPFirstToSelfLatencyMs(Uint32 p75SCPFirstToSelfLatencyMs) {
        this.p75SCPFirstToSelfLatencyMs = p75SCPFirstToSelfLatencyMs;
    }

    @Generated
    public void setP75SCPSelfToOtherLatencyMs(Uint32 p75SCPSelfToOtherLatencyMs) {
        this.p75SCPSelfToOtherLatencyMs = p75SCPSelfToOtherLatencyMs;
    }

    @Generated
    public void setLostSyncCount(Uint32 lostSyncCount) {
        this.lostSyncCount = lostSyncCount;
    }

    @Generated
    public void setIsValidator(Boolean isValidator) {
        this.isValidator = isValidator;
    }

    @Generated
    public void setMaxInboundPeerCount(Uint32 maxInboundPeerCount) {
        this.maxInboundPeerCount = maxInboundPeerCount;
    }

    @Generated
    public void setMaxOutboundPeerCount(Uint32 maxOutboundPeerCount) {
        this.maxOutboundPeerCount = maxOutboundPeerCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSlicedNodeData)) {
            return false;
        }
        TimeSlicedNodeData other = (TimeSlicedNodeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isValidator = this.getIsValidator();
        Boolean other$isValidator = other.getIsValidator();
        if (this$isValidator == null ? other$isValidator != null : !((Object)this$isValidator).equals(other$isValidator)) {
            return false;
        }
        Uint32 this$addedAuthenticatedPeers = this.getAddedAuthenticatedPeers();
        Uint32 other$addedAuthenticatedPeers = other.getAddedAuthenticatedPeers();
        if (this$addedAuthenticatedPeers == null ? other$addedAuthenticatedPeers != null : !((Object)this$addedAuthenticatedPeers).equals(other$addedAuthenticatedPeers)) {
            return false;
        }
        Uint32 this$droppedAuthenticatedPeers = this.getDroppedAuthenticatedPeers();
        Uint32 other$droppedAuthenticatedPeers = other.getDroppedAuthenticatedPeers();
        if (this$droppedAuthenticatedPeers == null ? other$droppedAuthenticatedPeers != null : !((Object)this$droppedAuthenticatedPeers).equals(other$droppedAuthenticatedPeers)) {
            return false;
        }
        Uint32 this$totalInboundPeerCount = this.getTotalInboundPeerCount();
        Uint32 other$totalInboundPeerCount = other.getTotalInboundPeerCount();
        if (this$totalInboundPeerCount == null ? other$totalInboundPeerCount != null : !((Object)this$totalInboundPeerCount).equals(other$totalInboundPeerCount)) {
            return false;
        }
        Uint32 this$totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        Uint32 other$totalOutboundPeerCount = other.getTotalOutboundPeerCount();
        if (this$totalOutboundPeerCount == null ? other$totalOutboundPeerCount != null : !((Object)this$totalOutboundPeerCount).equals(other$totalOutboundPeerCount)) {
            return false;
        }
        Uint32 this$p75SCPFirstToSelfLatencyMs = this.getP75SCPFirstToSelfLatencyMs();
        Uint32 other$p75SCPFirstToSelfLatencyMs = other.getP75SCPFirstToSelfLatencyMs();
        if (this$p75SCPFirstToSelfLatencyMs == null ? other$p75SCPFirstToSelfLatencyMs != null : !((Object)this$p75SCPFirstToSelfLatencyMs).equals(other$p75SCPFirstToSelfLatencyMs)) {
            return false;
        }
        Uint32 this$p75SCPSelfToOtherLatencyMs = this.getP75SCPSelfToOtherLatencyMs();
        Uint32 other$p75SCPSelfToOtherLatencyMs = other.getP75SCPSelfToOtherLatencyMs();
        if (this$p75SCPSelfToOtherLatencyMs == null ? other$p75SCPSelfToOtherLatencyMs != null : !((Object)this$p75SCPSelfToOtherLatencyMs).equals(other$p75SCPSelfToOtherLatencyMs)) {
            return false;
        }
        Uint32 this$lostSyncCount = this.getLostSyncCount();
        Uint32 other$lostSyncCount = other.getLostSyncCount();
        if (this$lostSyncCount == null ? other$lostSyncCount != null : !((Object)this$lostSyncCount).equals(other$lostSyncCount)) {
            return false;
        }
        Uint32 this$maxInboundPeerCount = this.getMaxInboundPeerCount();
        Uint32 other$maxInboundPeerCount = other.getMaxInboundPeerCount();
        if (this$maxInboundPeerCount == null ? other$maxInboundPeerCount != null : !((Object)this$maxInboundPeerCount).equals(other$maxInboundPeerCount)) {
            return false;
        }
        Uint32 this$maxOutboundPeerCount = this.getMaxOutboundPeerCount();
        Uint32 other$maxOutboundPeerCount = other.getMaxOutboundPeerCount();
        return !(this$maxOutboundPeerCount == null ? other$maxOutboundPeerCount != null : !((Object)this$maxOutboundPeerCount).equals(other$maxOutboundPeerCount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSlicedNodeData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isValidator = this.getIsValidator();
        result = result * 59 + ($isValidator == null ? 43 : ((Object)$isValidator).hashCode());
        Uint32 $addedAuthenticatedPeers = this.getAddedAuthenticatedPeers();
        result = result * 59 + ($addedAuthenticatedPeers == null ? 43 : ((Object)$addedAuthenticatedPeers).hashCode());
        Uint32 $droppedAuthenticatedPeers = this.getDroppedAuthenticatedPeers();
        result = result * 59 + ($droppedAuthenticatedPeers == null ? 43 : ((Object)$droppedAuthenticatedPeers).hashCode());
        Uint32 $totalInboundPeerCount = this.getTotalInboundPeerCount();
        result = result * 59 + ($totalInboundPeerCount == null ? 43 : ((Object)$totalInboundPeerCount).hashCode());
        Uint32 $totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        result = result * 59 + ($totalOutboundPeerCount == null ? 43 : ((Object)$totalOutboundPeerCount).hashCode());
        Uint32 $p75SCPFirstToSelfLatencyMs = this.getP75SCPFirstToSelfLatencyMs();
        result = result * 59 + ($p75SCPFirstToSelfLatencyMs == null ? 43 : ((Object)$p75SCPFirstToSelfLatencyMs).hashCode());
        Uint32 $p75SCPSelfToOtherLatencyMs = this.getP75SCPSelfToOtherLatencyMs();
        result = result * 59 + ($p75SCPSelfToOtherLatencyMs == null ? 43 : ((Object)$p75SCPSelfToOtherLatencyMs).hashCode());
        Uint32 $lostSyncCount = this.getLostSyncCount();
        result = result * 59 + ($lostSyncCount == null ? 43 : ((Object)$lostSyncCount).hashCode());
        Uint32 $maxInboundPeerCount = this.getMaxInboundPeerCount();
        result = result * 59 + ($maxInboundPeerCount == null ? 43 : ((Object)$maxInboundPeerCount).hashCode());
        Uint32 $maxOutboundPeerCount = this.getMaxOutboundPeerCount();
        result = result * 59 + ($maxOutboundPeerCount == null ? 43 : ((Object)$maxOutboundPeerCount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeSlicedNodeData(addedAuthenticatedPeers=" + this.getAddedAuthenticatedPeers() + ", droppedAuthenticatedPeers=" + this.getDroppedAuthenticatedPeers() + ", totalInboundPeerCount=" + this.getTotalInboundPeerCount() + ", totalOutboundPeerCount=" + this.getTotalOutboundPeerCount() + ", p75SCPFirstToSelfLatencyMs=" + this.getP75SCPFirstToSelfLatencyMs() + ", p75SCPSelfToOtherLatencyMs=" + this.getP75SCPSelfToOtherLatencyMs() + ", lostSyncCount=" + this.getLostSyncCount() + ", isValidator=" + this.getIsValidator() + ", maxInboundPeerCount=" + this.getMaxInboundPeerCount() + ", maxOutboundPeerCount=" + this.getMaxOutboundPeerCount() + ")";
    }

    @Generated
    public TimeSlicedNodeData() {
    }

    @Generated
    public TimeSlicedNodeData(Uint32 addedAuthenticatedPeers, Uint32 droppedAuthenticatedPeers, Uint32 totalInboundPeerCount, Uint32 totalOutboundPeerCount, Uint32 p75SCPFirstToSelfLatencyMs, Uint32 p75SCPSelfToOtherLatencyMs, Uint32 lostSyncCount, Boolean isValidator, Uint32 maxInboundPeerCount, Uint32 maxOutboundPeerCount) {
        this.addedAuthenticatedPeers = addedAuthenticatedPeers;
        this.droppedAuthenticatedPeers = droppedAuthenticatedPeers;
        this.totalInboundPeerCount = totalInboundPeerCount;
        this.totalOutboundPeerCount = totalOutboundPeerCount;
        this.p75SCPFirstToSelfLatencyMs = p75SCPFirstToSelfLatencyMs;
        this.p75SCPSelfToOtherLatencyMs = p75SCPSelfToOtherLatencyMs;
        this.lostSyncCount = lostSyncCount;
        this.isValidator = isValidator;
        this.maxInboundPeerCount = maxInboundPeerCount;
        this.maxOutboundPeerCount = maxOutboundPeerCount;
    }

    @Generated
    public static class TimeSlicedNodeDataBuilder {
        @Generated
        private Uint32 addedAuthenticatedPeers;
        @Generated
        private Uint32 droppedAuthenticatedPeers;
        @Generated
        private Uint32 totalInboundPeerCount;
        @Generated
        private Uint32 totalOutboundPeerCount;
        @Generated
        private Uint32 p75SCPFirstToSelfLatencyMs;
        @Generated
        private Uint32 p75SCPSelfToOtherLatencyMs;
        @Generated
        private Uint32 lostSyncCount;
        @Generated
        private Boolean isValidator;
        @Generated
        private Uint32 maxInboundPeerCount;
        @Generated
        private Uint32 maxOutboundPeerCount;

        @Generated
        TimeSlicedNodeDataBuilder() {
        }

        @Generated
        public TimeSlicedNodeDataBuilder addedAuthenticatedPeers(Uint32 addedAuthenticatedPeers) {
            this.addedAuthenticatedPeers = addedAuthenticatedPeers;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder droppedAuthenticatedPeers(Uint32 droppedAuthenticatedPeers) {
            this.droppedAuthenticatedPeers = droppedAuthenticatedPeers;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder totalInboundPeerCount(Uint32 totalInboundPeerCount) {
            this.totalInboundPeerCount = totalInboundPeerCount;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder totalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
            this.totalOutboundPeerCount = totalOutboundPeerCount;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder p75SCPFirstToSelfLatencyMs(Uint32 p75SCPFirstToSelfLatencyMs) {
            this.p75SCPFirstToSelfLatencyMs = p75SCPFirstToSelfLatencyMs;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder p75SCPSelfToOtherLatencyMs(Uint32 p75SCPSelfToOtherLatencyMs) {
            this.p75SCPSelfToOtherLatencyMs = p75SCPSelfToOtherLatencyMs;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder lostSyncCount(Uint32 lostSyncCount) {
            this.lostSyncCount = lostSyncCount;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder isValidator(Boolean isValidator) {
            this.isValidator = isValidator;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder maxInboundPeerCount(Uint32 maxInboundPeerCount) {
            this.maxInboundPeerCount = maxInboundPeerCount;
            return this;
        }

        @Generated
        public TimeSlicedNodeDataBuilder maxOutboundPeerCount(Uint32 maxOutboundPeerCount) {
            this.maxOutboundPeerCount = maxOutboundPeerCount;
            return this;
        }

        @Generated
        public TimeSlicedNodeData build() {
            return new TimeSlicedNodeData(this.addedAuthenticatedPeers, this.droppedAuthenticatedPeers, this.totalInboundPeerCount, this.totalOutboundPeerCount, this.p75SCPFirstToSelfLatencyMs, this.p75SCPSelfToOtherLatencyMs, this.lostSyncCount, this.isValidator, this.maxInboundPeerCount, this.maxOutboundPeerCount);
        }

        @Generated
        public String toString() {
            return "TimeSlicedNodeData.TimeSlicedNodeDataBuilder(addedAuthenticatedPeers=" + this.addedAuthenticatedPeers + ", droppedAuthenticatedPeers=" + this.droppedAuthenticatedPeers + ", totalInboundPeerCount=" + this.totalInboundPeerCount + ", totalOutboundPeerCount=" + this.totalOutboundPeerCount + ", p75SCPFirstToSelfLatencyMs=" + this.p75SCPFirstToSelfLatencyMs + ", p75SCPSelfToOtherLatencyMs=" + this.p75SCPSelfToOtherLatencyMs + ", lostSyncCount=" + this.lostSyncCount + ", isValidator=" + this.isValidator + ", maxInboundPeerCount=" + this.maxInboundPeerCount + ", maxOutboundPeerCount=" + this.maxOutboundPeerCount + ")";
        }
    }
}

