/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.TransactionPhase;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionSetV1
implements XdrElement {
    private Hash previousLedgerHash;
    private TransactionPhase[] phases;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.previousLedgerHash.encode(stream);
        int phasesSize = this.getPhases().length;
        stream.writeInt(phasesSize);
        for (int i = 0; i < phasesSize; ++i) {
            this.phases[i].encode(stream);
        }
    }

    public static TransactionSetV1 decode(XdrDataInputStream stream) throws IOException {
        TransactionSetV1 decodedTransactionSetV1 = new TransactionSetV1();
        decodedTransactionSetV1.previousLedgerHash = Hash.decode(stream);
        int phasesSize = stream.readInt();
        decodedTransactionSetV1.phases = new TransactionPhase[phasesSize];
        for (int i = 0; i < phasesSize; ++i) {
            decodedTransactionSetV1.phases[i] = TransactionPhase.decode(stream);
        }
        return decodedTransactionSetV1;
    }

    public static TransactionSetV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionSetV1.fromXdrByteArray(bytes);
    }

    public static TransactionSetV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionSetV1.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionSetV1Builder builder() {
        return new TransactionSetV1Builder();
    }

    @Generated
    public TransactionSetV1Builder toBuilder() {
        return new TransactionSetV1Builder().previousLedgerHash(this.previousLedgerHash).phases(this.phases);
    }

    @Generated
    public Hash getPreviousLedgerHash() {
        return this.previousLedgerHash;
    }

    @Generated
    public TransactionPhase[] getPhases() {
        return this.phases;
    }

    @Generated
    public void setPreviousLedgerHash(Hash previousLedgerHash) {
        this.previousLedgerHash = previousLedgerHash;
    }

    @Generated
    public void setPhases(TransactionPhase[] phases) {
        this.phases = phases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionSetV1)) {
            return false;
        }
        TransactionSetV1 other = (TransactionSetV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$previousLedgerHash = this.getPreviousLedgerHash();
        Hash other$previousLedgerHash = other.getPreviousLedgerHash();
        if (this$previousLedgerHash == null ? other$previousLedgerHash != null : !((Object)this$previousLedgerHash).equals(other$previousLedgerHash)) {
            return false;
        }
        return Arrays.deepEquals(this.getPhases(), other.getPhases());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionSetV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $previousLedgerHash = this.getPreviousLedgerHash();
        result = result * 59 + ($previousLedgerHash == null ? 43 : ((Object)$previousLedgerHash).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPhases());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionSetV1(previousLedgerHash=" + this.getPreviousLedgerHash() + ", phases=" + Arrays.deepToString(this.getPhases()) + ")";
    }

    @Generated
    public TransactionSetV1() {
    }

    @Generated
    public TransactionSetV1(Hash previousLedgerHash, TransactionPhase[] phases) {
        this.previousLedgerHash = previousLedgerHash;
        this.phases = phases;
    }

    @Generated
    public static class TransactionSetV1Builder {
        @Generated
        private Hash previousLedgerHash;
        @Generated
        private TransactionPhase[] phases;

        @Generated
        TransactionSetV1Builder() {
        }

        @Generated
        public TransactionSetV1Builder previousLedgerHash(Hash previousLedgerHash) {
            this.previousLedgerHash = previousLedgerHash;
            return this;
        }

        @Generated
        public TransactionSetV1Builder phases(TransactionPhase[] phases) {
            this.phases = phases;
            return this;
        }

        @Generated
        public TransactionSetV1 build() {
            return new TransactionSetV1(this.previousLedgerHash, this.phases);
        }

        @Generated
        public String toString() {
            return "TransactionSetV1.TransactionSetV1Builder(previousLedgerHash=" + this.previousLedgerHash + ", phases=" + Arrays.deepToString(this.phases) + ")";
        }
    }
}

