// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * FeeBumpTransactionEnvelope's original definition in the XDR file is:
 *
 * <pre>
 * struct FeeBumpTransactionEnvelope
 * {
 *     FeeBumpTransaction tx;
 *     /&#42; Each decorated signature is a signature over the SHA256 hash of
 *      &#42; a TransactionSignaturePayload &#42;/
 *     DecoratedSignature signatures&lt;20&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class FeeBumpTransactionEnvelope implements XdrElement {
  private FeeBumpTransaction tx;
  private DecoratedSignature[] signatures;

  public void encode(XdrDataOutputStream stream) throws IOException {
    tx.encode(stream);
    int signaturesSize = getSignatures().length;
    stream.writeInt(signaturesSize);
    for (int i = 0; i < signaturesSize; i++) {
      signatures[i].encode(stream);
    }
  }

  public static FeeBumpTransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
    FeeBumpTransactionEnvelope decodedFeeBumpTransactionEnvelope = new FeeBumpTransactionEnvelope();
    decodedFeeBumpTransactionEnvelope.tx = FeeBumpTransaction.decode(stream);
    int signaturesSize = stream.readInt();
    decodedFeeBumpTransactionEnvelope.signatures = new DecoratedSignature[signaturesSize];
    for (int i = 0; i < signaturesSize; i++) {
      decodedFeeBumpTransactionEnvelope.signatures[i] = DecoratedSignature.decode(stream);
    }
    return decodedFeeBumpTransactionEnvelope;
  }

  public static FeeBumpTransactionEnvelope fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static FeeBumpTransactionEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
