// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionEnvelope's original definition in the XDR file is:
 *
 * <pre>
 * union TransactionEnvelope switch (EnvelopeType type)
 * {
 * case ENVELOPE_TYPE_TX_V0:
 *     TransactionV0Envelope v0;
 * case ENVELOPE_TYPE_TX:
 *     TransactionV1Envelope v1;
 * case ENVELOPE_TYPE_TX_FEE_BUMP:
 *     FeeBumpTransactionEnvelope feeBump;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionEnvelope implements XdrElement {
  private EnvelopeType discriminant;
  private TransactionV0Envelope v0;
  private TransactionV1Envelope v1;
  private FeeBumpTransactionEnvelope feeBump;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ENVELOPE_TYPE_TX_V0:
        v0.encode(stream);
        break;
      case ENVELOPE_TYPE_TX:
        v1.encode(stream);
        break;
      case ENVELOPE_TYPE_TX_FEE_BUMP:
        feeBump.encode(stream);
        break;
    }
  }

  public static TransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
    TransactionEnvelope decodedTransactionEnvelope = new TransactionEnvelope();
    EnvelopeType discriminant = EnvelopeType.decode(stream);
    decodedTransactionEnvelope.setDiscriminant(discriminant);
    switch (decodedTransactionEnvelope.getDiscriminant()) {
      case ENVELOPE_TYPE_TX_V0:
        decodedTransactionEnvelope.v0 = TransactionV0Envelope.decode(stream);
        break;
      case ENVELOPE_TYPE_TX:
        decodedTransactionEnvelope.v1 = TransactionV1Envelope.decode(stream);
        break;
      case ENVELOPE_TYPE_TX_FEE_BUMP:
        decodedTransactionEnvelope.feeBump = FeeBumpTransactionEnvelope.decode(stream);
        break;
    }
    return decodedTransactionEnvelope;
  }

  public static TransactionEnvelope fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
