/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AllowTrustOp
implements XdrElement {
    private AccountID trustor;
    private AssetCode asset;
    private Uint32 authorize;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.trustor.encode(stream);
        this.asset.encode(stream);
        this.authorize.encode(stream);
    }

    public static AllowTrustOp decode(XdrDataInputStream stream) throws IOException {
        AllowTrustOp decodedAllowTrustOp = new AllowTrustOp();
        decodedAllowTrustOp.trustor = AccountID.decode(stream);
        decodedAllowTrustOp.asset = AssetCode.decode(stream);
        decodedAllowTrustOp.authorize = Uint32.decode(stream);
        return decodedAllowTrustOp;
    }

    public static AllowTrustOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AllowTrustOp.fromXdrByteArray(bytes);
    }

    public static AllowTrustOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AllowTrustOp.decode(xdrDataInputStream);
    }

    @Generated
    public static AllowTrustOpBuilder builder() {
        return new AllowTrustOpBuilder();
    }

    @Generated
    public AllowTrustOpBuilder toBuilder() {
        return new AllowTrustOpBuilder().trustor(this.trustor).asset(this.asset).authorize(this.authorize);
    }

    @Generated
    public AccountID getTrustor() {
        return this.trustor;
    }

    @Generated
    public AssetCode getAsset() {
        return this.asset;
    }

    @Generated
    public Uint32 getAuthorize() {
        return this.authorize;
    }

    @Generated
    public void setTrustor(AccountID trustor) {
        this.trustor = trustor;
    }

    @Generated
    public void setAsset(AssetCode asset) {
        this.asset = asset;
    }

    @Generated
    public void setAuthorize(Uint32 authorize) {
        this.authorize = authorize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowTrustOp)) {
            return false;
        }
        AllowTrustOp other = (AllowTrustOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$trustor = this.getTrustor();
        AccountID other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !((Object)this$trustor).equals(other$trustor)) {
            return false;
        }
        AssetCode this$asset = this.getAsset();
        AssetCode other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Uint32 this$authorize = this.getAuthorize();
        Uint32 other$authorize = other.getAuthorize();
        return !(this$authorize == null ? other$authorize != null : !((Object)this$authorize).equals(other$authorize));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowTrustOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : ((Object)$trustor).hashCode());
        AssetCode $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Uint32 $authorize = this.getAuthorize();
        result = result * 59 + ($authorize == null ? 43 : ((Object)$authorize).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AllowTrustOp(trustor=" + this.getTrustor() + ", asset=" + this.getAsset() + ", authorize=" + this.getAuthorize() + ")";
    }

    @Generated
    public AllowTrustOp() {
    }

    @Generated
    public AllowTrustOp(AccountID trustor, AssetCode asset, Uint32 authorize) {
        this.trustor = trustor;
        this.asset = asset;
        this.authorize = authorize;
    }

    @Generated
    public static class AllowTrustOpBuilder {
        @Generated
        private AccountID trustor;
        @Generated
        private AssetCode asset;
        @Generated
        private Uint32 authorize;

        @Generated
        AllowTrustOpBuilder() {
        }

        @Generated
        public AllowTrustOpBuilder trustor(AccountID trustor) {
            this.trustor = trustor;
            return this;
        }

        @Generated
        public AllowTrustOpBuilder asset(AssetCode asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public AllowTrustOpBuilder authorize(Uint32 authorize) {
            this.authorize = authorize;
            return this;
        }

        @Generated
        public AllowTrustOp build() {
            return new AllowTrustOp(this.trustor, this.asset, this.authorize);
        }

        @Generated
        public String toString() {
            return "AllowTrustOp.AllowTrustOpBuilder(trustor=" + this.trustor + ", asset=" + this.asset + ", authorize=" + this.authorize + ")";
        }
    }
}

