/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BucketEntryType;
import org.stellar.sdk.xdr.BucketMetadata;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BucketEntry
implements XdrElement {
    private BucketEntryType discriminant;
    private LedgerEntry liveEntry;
    private LedgerKey deadEntry;
    private BucketMetadata metaEntry;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case LIVEENTRY: 
            case INITENTRY: {
                this.liveEntry.encode(stream);
                break;
            }
            case DEADENTRY: {
                this.deadEntry.encode(stream);
                break;
            }
            case METAENTRY: {
                this.metaEntry.encode(stream);
            }
        }
    }

    public static BucketEntry decode(XdrDataInputStream stream) throws IOException {
        BucketEntry decodedBucketEntry = new BucketEntry();
        BucketEntryType discriminant = BucketEntryType.decode(stream);
        decodedBucketEntry.setDiscriminant(discriminant);
        switch (decodedBucketEntry.getDiscriminant()) {
            case LIVEENTRY: 
            case INITENTRY: {
                decodedBucketEntry.liveEntry = LedgerEntry.decode(stream);
                break;
            }
            case DEADENTRY: {
                decodedBucketEntry.deadEntry = LedgerKey.decode(stream);
                break;
            }
            case METAENTRY: {
                decodedBucketEntry.metaEntry = BucketMetadata.decode(stream);
            }
        }
        return decodedBucketEntry;
    }

    public static BucketEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BucketEntry.fromXdrByteArray(bytes);
    }

    public static BucketEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BucketEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static BucketEntryBuilder builder() {
        return new BucketEntryBuilder();
    }

    @Generated
    public BucketEntryBuilder toBuilder() {
        return new BucketEntryBuilder().discriminant(this.discriminant).liveEntry(this.liveEntry).deadEntry(this.deadEntry).metaEntry(this.metaEntry);
    }

    @Generated
    public BucketEntryType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public LedgerEntry getLiveEntry() {
        return this.liveEntry;
    }

    @Generated
    public LedgerKey getDeadEntry() {
        return this.deadEntry;
    }

    @Generated
    public BucketMetadata getMetaEntry() {
        return this.metaEntry;
    }

    @Generated
    public void setDiscriminant(BucketEntryType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setLiveEntry(LedgerEntry liveEntry) {
        this.liveEntry = liveEntry;
    }

    @Generated
    public void setDeadEntry(LedgerKey deadEntry) {
        this.deadEntry = deadEntry;
    }

    @Generated
    public void setMetaEntry(BucketMetadata metaEntry) {
        this.metaEntry = metaEntry;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketEntry)) {
            return false;
        }
        BucketEntry other = (BucketEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BucketEntryType this$discriminant = this.getDiscriminant();
        BucketEntryType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        LedgerEntry this$liveEntry = this.getLiveEntry();
        LedgerEntry other$liveEntry = other.getLiveEntry();
        if (this$liveEntry == null ? other$liveEntry != null : !((Object)this$liveEntry).equals(other$liveEntry)) {
            return false;
        }
        LedgerKey this$deadEntry = this.getDeadEntry();
        LedgerKey other$deadEntry = other.getDeadEntry();
        if (this$deadEntry == null ? other$deadEntry != null : !((Object)this$deadEntry).equals(other$deadEntry)) {
            return false;
        }
        BucketMetadata this$metaEntry = this.getMetaEntry();
        BucketMetadata other$metaEntry = other.getMetaEntry();
        return !(this$metaEntry == null ? other$metaEntry != null : !((Object)this$metaEntry).equals(other$metaEntry));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BucketEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BucketEntryType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        LedgerEntry $liveEntry = this.getLiveEntry();
        result = result * 59 + ($liveEntry == null ? 43 : ((Object)$liveEntry).hashCode());
        LedgerKey $deadEntry = this.getDeadEntry();
        result = result * 59 + ($deadEntry == null ? 43 : ((Object)$deadEntry).hashCode());
        BucketMetadata $metaEntry = this.getMetaEntry();
        result = result * 59 + ($metaEntry == null ? 43 : ((Object)$metaEntry).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BucketEntry(discriminant=" + this.getDiscriminant() + ", liveEntry=" + this.getLiveEntry() + ", deadEntry=" + this.getDeadEntry() + ", metaEntry=" + this.getMetaEntry() + ")";
    }

    @Generated
    public BucketEntry() {
    }

    @Generated
    public BucketEntry(BucketEntryType discriminant, LedgerEntry liveEntry, LedgerKey deadEntry, BucketMetadata metaEntry) {
        this.discriminant = discriminant;
        this.liveEntry = liveEntry;
        this.deadEntry = deadEntry;
        this.metaEntry = metaEntry;
    }

    @Generated
    public static class BucketEntryBuilder {
        @Generated
        private BucketEntryType discriminant;
        @Generated
        private LedgerEntry liveEntry;
        @Generated
        private LedgerKey deadEntry;
        @Generated
        private BucketMetadata metaEntry;

        @Generated
        BucketEntryBuilder() {
        }

        @Generated
        public BucketEntryBuilder discriminant(BucketEntryType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public BucketEntryBuilder liveEntry(LedgerEntry liveEntry) {
            this.liveEntry = liveEntry;
            return this;
        }

        @Generated
        public BucketEntryBuilder deadEntry(LedgerKey deadEntry) {
            this.deadEntry = deadEntry;
            return this;
        }

        @Generated
        public BucketEntryBuilder metaEntry(BucketMetadata metaEntry) {
            this.metaEntry = metaEntry;
            return this;
        }

        @Generated
        public BucketEntry build() {
            return new BucketEntry(this.discriminant, this.liveEntry, this.deadEntry, this.metaEntry);
        }

        @Generated
        public String toString() {
            return "BucketEntry.BucketEntryBuilder(discriminant=" + this.discriminant + ", liveEntry=" + this.liveEntry + ", deadEntry=" + this.deadEntry + ", metaEntry=" + this.metaEntry + ")";
        }
    }
}

