/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ClaimClaimableBalanceResultCode implements XdrElement
{
    CLAIM_CLAIMABLE_BALANCE_SUCCESS(0),
    CLAIM_CLAIMABLE_BALANCE_DOES_NOT_EXIST(-1),
    CLAIM_CLAIMABLE_BALANCE_CANNOT_CLAIM(-2),
    CLAIM_CLAIMABLE_BALANCE_LINE_FULL(-3),
    CLAIM_CLAIMABLE_BALANCE_NO_TRUST(-4),
    CLAIM_CLAIMABLE_BALANCE_NOT_AUTHORIZED(-5);

    private final int value;

    private ClaimClaimableBalanceResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ClaimClaimableBalanceResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CLAIM_CLAIMABLE_BALANCE_SUCCESS;
            }
            case -1: {
                return CLAIM_CLAIMABLE_BALANCE_DOES_NOT_EXIST;
            }
            case -2: {
                return CLAIM_CLAIMABLE_BALANCE_CANNOT_CLAIM;
            }
            case -3: {
                return CLAIM_CLAIMABLE_BALANCE_LINE_FULL;
            }
            case -4: {
                return CLAIM_CLAIMABLE_BALANCE_NO_TRUST;
            }
            case -5: {
                return CLAIM_CLAIMABLE_BALANCE_NOT_AUTHORIZED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ClaimClaimableBalanceResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimClaimableBalanceResultCode.fromXdrByteArray(bytes);
    }

    public static ClaimClaimableBalanceResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimClaimableBalanceResultCode.decode(xdrDataInputStream);
    }
}

