/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerHeaderExtensionV1;
import org.stellar.sdk.xdr.StellarValue;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerHeader
implements XdrElement {
    private Uint32 ledgerVersion;
    private Hash previousLedgerHash;
    private StellarValue scpValue;
    private Hash txSetResultHash;
    private Hash bucketListHash;
    private Uint32 ledgerSeq;
    private Int64 totalCoins;
    private Int64 feePool;
    private Uint32 inflationSeq;
    private Uint64 idPool;
    private Uint32 baseFee;
    private Uint32 baseReserve;
    private Uint32 maxTxSetSize;
    private Hash[] skipList;
    private LedgerHeaderExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerVersion.encode(stream);
        this.previousLedgerHash.encode(stream);
        this.scpValue.encode(stream);
        this.txSetResultHash.encode(stream);
        this.bucketListHash.encode(stream);
        this.ledgerSeq.encode(stream);
        this.totalCoins.encode(stream);
        this.feePool.encode(stream);
        this.inflationSeq.encode(stream);
        this.idPool.encode(stream);
        this.baseFee.encode(stream);
        this.baseReserve.encode(stream);
        this.maxTxSetSize.encode(stream);
        int skipListSize = this.getSkipList().length;
        for (int i = 0; i < skipListSize; ++i) {
            this.skipList[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static LedgerHeader decode(XdrDataInputStream stream) throws IOException {
        LedgerHeader decodedLedgerHeader = new LedgerHeader();
        decodedLedgerHeader.ledgerVersion = Uint32.decode(stream);
        decodedLedgerHeader.previousLedgerHash = Hash.decode(stream);
        decodedLedgerHeader.scpValue = StellarValue.decode(stream);
        decodedLedgerHeader.txSetResultHash = Hash.decode(stream);
        decodedLedgerHeader.bucketListHash = Hash.decode(stream);
        decodedLedgerHeader.ledgerSeq = Uint32.decode(stream);
        decodedLedgerHeader.totalCoins = Int64.decode(stream);
        decodedLedgerHeader.feePool = Int64.decode(stream);
        decodedLedgerHeader.inflationSeq = Uint32.decode(stream);
        decodedLedgerHeader.idPool = Uint64.decode(stream);
        decodedLedgerHeader.baseFee = Uint32.decode(stream);
        decodedLedgerHeader.baseReserve = Uint32.decode(stream);
        decodedLedgerHeader.maxTxSetSize = Uint32.decode(stream);
        int skipListSize = 4;
        decodedLedgerHeader.skipList = new Hash[skipListSize];
        for (int i = 0; i < skipListSize; ++i) {
            decodedLedgerHeader.skipList[i] = Hash.decode(stream);
        }
        decodedLedgerHeader.ext = LedgerHeaderExt.decode(stream);
        return decodedLedgerHeader;
    }

    public static LedgerHeader fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeader.fromXdrByteArray(bytes);
    }

    public static LedgerHeader fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeader.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerHeaderBuilder builder() {
        return new LedgerHeaderBuilder();
    }

    @Generated
    public LedgerHeaderBuilder toBuilder() {
        return new LedgerHeaderBuilder().ledgerVersion(this.ledgerVersion).previousLedgerHash(this.previousLedgerHash).scpValue(this.scpValue).txSetResultHash(this.txSetResultHash).bucketListHash(this.bucketListHash).ledgerSeq(this.ledgerSeq).totalCoins(this.totalCoins).feePool(this.feePool).inflationSeq(this.inflationSeq).idPool(this.idPool).baseFee(this.baseFee).baseReserve(this.baseReserve).maxTxSetSize(this.maxTxSetSize).skipList(this.skipList).ext(this.ext);
    }

    @Generated
    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    @Generated
    public Hash getPreviousLedgerHash() {
        return this.previousLedgerHash;
    }

    @Generated
    public StellarValue getScpValue() {
        return this.scpValue;
    }

    @Generated
    public Hash getTxSetResultHash() {
        return this.txSetResultHash;
    }

    @Generated
    public Hash getBucketListHash() {
        return this.bucketListHash;
    }

    @Generated
    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    @Generated
    public Int64 getTotalCoins() {
        return this.totalCoins;
    }

    @Generated
    public Int64 getFeePool() {
        return this.feePool;
    }

    @Generated
    public Uint32 getInflationSeq() {
        return this.inflationSeq;
    }

    @Generated
    public Uint64 getIdPool() {
        return this.idPool;
    }

    @Generated
    public Uint32 getBaseFee() {
        return this.baseFee;
    }

    @Generated
    public Uint32 getBaseReserve() {
        return this.baseReserve;
    }

    @Generated
    public Uint32 getMaxTxSetSize() {
        return this.maxTxSetSize;
    }

    @Generated
    public Hash[] getSkipList() {
        return this.skipList;
    }

    @Generated
    public LedgerHeaderExt getExt() {
        return this.ext;
    }

    @Generated
    public void setLedgerVersion(Uint32 ledgerVersion) {
        this.ledgerVersion = ledgerVersion;
    }

    @Generated
    public void setPreviousLedgerHash(Hash previousLedgerHash) {
        this.previousLedgerHash = previousLedgerHash;
    }

    @Generated
    public void setScpValue(StellarValue scpValue) {
        this.scpValue = scpValue;
    }

    @Generated
    public void setTxSetResultHash(Hash txSetResultHash) {
        this.txSetResultHash = txSetResultHash;
    }

    @Generated
    public void setBucketListHash(Hash bucketListHash) {
        this.bucketListHash = bucketListHash;
    }

    @Generated
    public void setLedgerSeq(Uint32 ledgerSeq) {
        this.ledgerSeq = ledgerSeq;
    }

    @Generated
    public void setTotalCoins(Int64 totalCoins) {
        this.totalCoins = totalCoins;
    }

    @Generated
    public void setFeePool(Int64 feePool) {
        this.feePool = feePool;
    }

    @Generated
    public void setInflationSeq(Uint32 inflationSeq) {
        this.inflationSeq = inflationSeq;
    }

    @Generated
    public void setIdPool(Uint64 idPool) {
        this.idPool = idPool;
    }

    @Generated
    public void setBaseFee(Uint32 baseFee) {
        this.baseFee = baseFee;
    }

    @Generated
    public void setBaseReserve(Uint32 baseReserve) {
        this.baseReserve = baseReserve;
    }

    @Generated
    public void setMaxTxSetSize(Uint32 maxTxSetSize) {
        this.maxTxSetSize = maxTxSetSize;
    }

    @Generated
    public void setSkipList(Hash[] skipList) {
        this.skipList = skipList;
    }

    @Generated
    public void setExt(LedgerHeaderExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerHeader)) {
            return false;
        }
        LedgerHeader other = (LedgerHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$ledgerVersion = this.getLedgerVersion();
        Uint32 other$ledgerVersion = other.getLedgerVersion();
        if (this$ledgerVersion == null ? other$ledgerVersion != null : !((Object)this$ledgerVersion).equals(other$ledgerVersion)) {
            return false;
        }
        Hash this$previousLedgerHash = this.getPreviousLedgerHash();
        Hash other$previousLedgerHash = other.getPreviousLedgerHash();
        if (this$previousLedgerHash == null ? other$previousLedgerHash != null : !((Object)this$previousLedgerHash).equals(other$previousLedgerHash)) {
            return false;
        }
        StellarValue this$scpValue = this.getScpValue();
        StellarValue other$scpValue = other.getScpValue();
        if (this$scpValue == null ? other$scpValue != null : !((Object)this$scpValue).equals(other$scpValue)) {
            return false;
        }
        Hash this$txSetResultHash = this.getTxSetResultHash();
        Hash other$txSetResultHash = other.getTxSetResultHash();
        if (this$txSetResultHash == null ? other$txSetResultHash != null : !((Object)this$txSetResultHash).equals(other$txSetResultHash)) {
            return false;
        }
        Hash this$bucketListHash = this.getBucketListHash();
        Hash other$bucketListHash = other.getBucketListHash();
        if (this$bucketListHash == null ? other$bucketListHash != null : !((Object)this$bucketListHash).equals(other$bucketListHash)) {
            return false;
        }
        Uint32 this$ledgerSeq = this.getLedgerSeq();
        Uint32 other$ledgerSeq = other.getLedgerSeq();
        if (this$ledgerSeq == null ? other$ledgerSeq != null : !((Object)this$ledgerSeq).equals(other$ledgerSeq)) {
            return false;
        }
        Int64 this$totalCoins = this.getTotalCoins();
        Int64 other$totalCoins = other.getTotalCoins();
        if (this$totalCoins == null ? other$totalCoins != null : !((Object)this$totalCoins).equals(other$totalCoins)) {
            return false;
        }
        Int64 this$feePool = this.getFeePool();
        Int64 other$feePool = other.getFeePool();
        if (this$feePool == null ? other$feePool != null : !((Object)this$feePool).equals(other$feePool)) {
            return false;
        }
        Uint32 this$inflationSeq = this.getInflationSeq();
        Uint32 other$inflationSeq = other.getInflationSeq();
        if (this$inflationSeq == null ? other$inflationSeq != null : !((Object)this$inflationSeq).equals(other$inflationSeq)) {
            return false;
        }
        Uint64 this$idPool = this.getIdPool();
        Uint64 other$idPool = other.getIdPool();
        if (this$idPool == null ? other$idPool != null : !((Object)this$idPool).equals(other$idPool)) {
            return false;
        }
        Uint32 this$baseFee = this.getBaseFee();
        Uint32 other$baseFee = other.getBaseFee();
        if (this$baseFee == null ? other$baseFee != null : !((Object)this$baseFee).equals(other$baseFee)) {
            return false;
        }
        Uint32 this$baseReserve = this.getBaseReserve();
        Uint32 other$baseReserve = other.getBaseReserve();
        if (this$baseReserve == null ? other$baseReserve != null : !((Object)this$baseReserve).equals(other$baseReserve)) {
            return false;
        }
        Uint32 this$maxTxSetSize = this.getMaxTxSetSize();
        Uint32 other$maxTxSetSize = other.getMaxTxSetSize();
        if (this$maxTxSetSize == null ? other$maxTxSetSize != null : !((Object)this$maxTxSetSize).equals(other$maxTxSetSize)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSkipList(), other.getSkipList())) {
            return false;
        }
        LedgerHeaderExt this$ext = this.getExt();
        LedgerHeaderExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerHeader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $ledgerVersion = this.getLedgerVersion();
        result = result * 59 + ($ledgerVersion == null ? 43 : ((Object)$ledgerVersion).hashCode());
        Hash $previousLedgerHash = this.getPreviousLedgerHash();
        result = result * 59 + ($previousLedgerHash == null ? 43 : ((Object)$previousLedgerHash).hashCode());
        StellarValue $scpValue = this.getScpValue();
        result = result * 59 + ($scpValue == null ? 43 : ((Object)$scpValue).hashCode());
        Hash $txSetResultHash = this.getTxSetResultHash();
        result = result * 59 + ($txSetResultHash == null ? 43 : ((Object)$txSetResultHash).hashCode());
        Hash $bucketListHash = this.getBucketListHash();
        result = result * 59 + ($bucketListHash == null ? 43 : ((Object)$bucketListHash).hashCode());
        Uint32 $ledgerSeq = this.getLedgerSeq();
        result = result * 59 + ($ledgerSeq == null ? 43 : ((Object)$ledgerSeq).hashCode());
        Int64 $totalCoins = this.getTotalCoins();
        result = result * 59 + ($totalCoins == null ? 43 : ((Object)$totalCoins).hashCode());
        Int64 $feePool = this.getFeePool();
        result = result * 59 + ($feePool == null ? 43 : ((Object)$feePool).hashCode());
        Uint32 $inflationSeq = this.getInflationSeq();
        result = result * 59 + ($inflationSeq == null ? 43 : ((Object)$inflationSeq).hashCode());
        Uint64 $idPool = this.getIdPool();
        result = result * 59 + ($idPool == null ? 43 : ((Object)$idPool).hashCode());
        Uint32 $baseFee = this.getBaseFee();
        result = result * 59 + ($baseFee == null ? 43 : ((Object)$baseFee).hashCode());
        Uint32 $baseReserve = this.getBaseReserve();
        result = result * 59 + ($baseReserve == null ? 43 : ((Object)$baseReserve).hashCode());
        Uint32 $maxTxSetSize = this.getMaxTxSetSize();
        result = result * 59 + ($maxTxSetSize == null ? 43 : ((Object)$maxTxSetSize).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSkipList());
        LedgerHeaderExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerHeader(ledgerVersion=" + this.getLedgerVersion() + ", previousLedgerHash=" + this.getPreviousLedgerHash() + ", scpValue=" + this.getScpValue() + ", txSetResultHash=" + this.getTxSetResultHash() + ", bucketListHash=" + this.getBucketListHash() + ", ledgerSeq=" + this.getLedgerSeq() + ", totalCoins=" + this.getTotalCoins() + ", feePool=" + this.getFeePool() + ", inflationSeq=" + this.getInflationSeq() + ", idPool=" + this.getIdPool() + ", baseFee=" + this.getBaseFee() + ", baseReserve=" + this.getBaseReserve() + ", maxTxSetSize=" + this.getMaxTxSetSize() + ", skipList=" + Arrays.deepToString(this.getSkipList()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public LedgerHeader() {
    }

    @Generated
    public LedgerHeader(Uint32 ledgerVersion, Hash previousLedgerHash, StellarValue scpValue, Hash txSetResultHash, Hash bucketListHash, Uint32 ledgerSeq, Int64 totalCoins, Int64 feePool, Uint32 inflationSeq, Uint64 idPool, Uint32 baseFee, Uint32 baseReserve, Uint32 maxTxSetSize, Hash[] skipList, LedgerHeaderExt ext) {
        this.ledgerVersion = ledgerVersion;
        this.previousLedgerHash = previousLedgerHash;
        this.scpValue = scpValue;
        this.txSetResultHash = txSetResultHash;
        this.bucketListHash = bucketListHash;
        this.ledgerSeq = ledgerSeq;
        this.totalCoins = totalCoins;
        this.feePool = feePool;
        this.inflationSeq = inflationSeq;
        this.idPool = idPool;
        this.baseFee = baseFee;
        this.baseReserve = baseReserve;
        this.maxTxSetSize = maxTxSetSize;
        this.skipList = skipList;
        this.ext = ext;
    }

    public static class LedgerHeaderExt
    implements XdrElement {
        private Integer discriminant;
        private LedgerHeaderExtensionV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static LedgerHeaderExt decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderExt decodedLedgerHeaderExt = new LedgerHeaderExt();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderExt.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedLedgerHeaderExt.v1 = LedgerHeaderExtensionV1.decode(stream);
                }
            }
            return decodedLedgerHeaderExt;
        }

        public static LedgerHeaderExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerHeaderExt.fromXdrByteArray(bytes);
        }

        public static LedgerHeaderExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerHeaderExt.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerHeaderExtBuilder builder() {
            return new LedgerHeaderExtBuilder();
        }

        @Generated
        public LedgerHeaderExtBuilder toBuilder() {
            return new LedgerHeaderExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public LedgerHeaderExtensionV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(LedgerHeaderExtensionV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerHeaderExt)) {
                return false;
            }
            LedgerHeaderExt other = (LedgerHeaderExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            LedgerHeaderExtensionV1 this$v1 = this.getV1();
            LedgerHeaderExtensionV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerHeaderExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            LedgerHeaderExtensionV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerHeader.LedgerHeaderExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public LedgerHeaderExt() {
        }

        @Generated
        public LedgerHeaderExt(Integer discriminant, LedgerHeaderExtensionV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class LedgerHeaderExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private LedgerHeaderExtensionV1 v1;

            @Generated
            LedgerHeaderExtBuilder() {
            }

            @Generated
            public LedgerHeaderExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public LedgerHeaderExtBuilder v1(LedgerHeaderExtensionV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public LedgerHeaderExt build() {
                return new LedgerHeaderExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "LedgerHeader.LedgerHeaderExt.LedgerHeaderExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }

    @Generated
    public static class LedgerHeaderBuilder {
        @Generated
        private Uint32 ledgerVersion;
        @Generated
        private Hash previousLedgerHash;
        @Generated
        private StellarValue scpValue;
        @Generated
        private Hash txSetResultHash;
        @Generated
        private Hash bucketListHash;
        @Generated
        private Uint32 ledgerSeq;
        @Generated
        private Int64 totalCoins;
        @Generated
        private Int64 feePool;
        @Generated
        private Uint32 inflationSeq;
        @Generated
        private Uint64 idPool;
        @Generated
        private Uint32 baseFee;
        @Generated
        private Uint32 baseReserve;
        @Generated
        private Uint32 maxTxSetSize;
        @Generated
        private Hash[] skipList;
        @Generated
        private LedgerHeaderExt ext;

        @Generated
        LedgerHeaderBuilder() {
        }

        @Generated
        public LedgerHeaderBuilder ledgerVersion(Uint32 ledgerVersion) {
            this.ledgerVersion = ledgerVersion;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder previousLedgerHash(Hash previousLedgerHash) {
            this.previousLedgerHash = previousLedgerHash;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder scpValue(StellarValue scpValue) {
            this.scpValue = scpValue;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder txSetResultHash(Hash txSetResultHash) {
            this.txSetResultHash = txSetResultHash;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder bucketListHash(Hash bucketListHash) {
            this.bucketListHash = bucketListHash;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder ledgerSeq(Uint32 ledgerSeq) {
            this.ledgerSeq = ledgerSeq;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder totalCoins(Int64 totalCoins) {
            this.totalCoins = totalCoins;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder feePool(Int64 feePool) {
            this.feePool = feePool;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder inflationSeq(Uint32 inflationSeq) {
            this.inflationSeq = inflationSeq;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder idPool(Uint64 idPool) {
            this.idPool = idPool;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder baseFee(Uint32 baseFee) {
            this.baseFee = baseFee;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder baseReserve(Uint32 baseReserve) {
            this.baseReserve = baseReserve;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder maxTxSetSize(Uint32 maxTxSetSize) {
            this.maxTxSetSize = maxTxSetSize;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder skipList(Hash[] skipList) {
            this.skipList = skipList;
            return this;
        }

        @Generated
        public LedgerHeaderBuilder ext(LedgerHeaderExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public LedgerHeader build() {
            return new LedgerHeader(this.ledgerVersion, this.previousLedgerHash, this.scpValue, this.txSetResultHash, this.bucketListHash, this.ledgerSeq, this.totalCoins, this.feePool, this.inflationSeq, this.idPool, this.baseFee, this.baseReserve, this.maxTxSetSize, this.skipList, this.ext);
        }

        @Generated
        public String toString() {
            return "LedgerHeader.LedgerHeaderBuilder(ledgerVersion=" + this.ledgerVersion + ", previousLedgerHash=" + this.previousLedgerHash + ", scpValue=" + this.scpValue + ", txSetResultHash=" + this.txSetResultHash + ", bucketListHash=" + this.bucketListHash + ", ledgerSeq=" + this.ledgerSeq + ", totalCoins=" + this.totalCoins + ", feePool=" + this.feePool + ", inflationSeq=" + this.inflationSeq + ", idPool=" + this.idPool + ", baseFee=" + this.baseFee + ", baseReserve=" + this.baseReserve + ", maxTxSetSize=" + this.maxTxSetSize + ", skipList=" + Arrays.deepToString(this.skipList) + ", ext=" + this.ext + ")";
        }
    }
}

