/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.SCPQuorumSet;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PersistedSCPStateV1
implements XdrElement {
    private SCPEnvelope[] scpEnvelopes;
    private SCPQuorumSet[] quorumSets;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int scpEnvelopesSize = this.getScpEnvelopes().length;
        stream.writeInt(scpEnvelopesSize);
        for (int i = 0; i < scpEnvelopesSize; ++i) {
            this.scpEnvelopes[i].encode(stream);
        }
        int quorumSetsSize = this.getQuorumSets().length;
        stream.writeInt(quorumSetsSize);
        for (int i = 0; i < quorumSetsSize; ++i) {
            this.quorumSets[i].encode(stream);
        }
    }

    public static PersistedSCPStateV1 decode(XdrDataInputStream stream) throws IOException {
        PersistedSCPStateV1 decodedPersistedSCPStateV1 = new PersistedSCPStateV1();
        int scpEnvelopesSize = stream.readInt();
        decodedPersistedSCPStateV1.scpEnvelopes = new SCPEnvelope[scpEnvelopesSize];
        for (int i = 0; i < scpEnvelopesSize; ++i) {
            decodedPersistedSCPStateV1.scpEnvelopes[i] = SCPEnvelope.decode(stream);
        }
        int quorumSetsSize = stream.readInt();
        decodedPersistedSCPStateV1.quorumSets = new SCPQuorumSet[quorumSetsSize];
        for (int i = 0; i < quorumSetsSize; ++i) {
            decodedPersistedSCPStateV1.quorumSets[i] = SCPQuorumSet.decode(stream);
        }
        return decodedPersistedSCPStateV1;
    }

    public static PersistedSCPStateV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PersistedSCPStateV1.fromXdrByteArray(bytes);
    }

    public static PersistedSCPStateV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PersistedSCPStateV1.decode(xdrDataInputStream);
    }

    @Generated
    public static PersistedSCPStateV1Builder builder() {
        return new PersistedSCPStateV1Builder();
    }

    @Generated
    public PersistedSCPStateV1Builder toBuilder() {
        return new PersistedSCPStateV1Builder().scpEnvelopes(this.scpEnvelopes).quorumSets(this.quorumSets);
    }

    @Generated
    public SCPEnvelope[] getScpEnvelopes() {
        return this.scpEnvelopes;
    }

    @Generated
    public SCPQuorumSet[] getQuorumSets() {
        return this.quorumSets;
    }

    @Generated
    public void setScpEnvelopes(SCPEnvelope[] scpEnvelopes) {
        this.scpEnvelopes = scpEnvelopes;
    }

    @Generated
    public void setQuorumSets(SCPQuorumSet[] quorumSets) {
        this.quorumSets = quorumSets;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistedSCPStateV1)) {
            return false;
        }
        PersistedSCPStateV1 other = (PersistedSCPStateV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScpEnvelopes(), other.getScpEnvelopes())) {
            return false;
        }
        return Arrays.deepEquals(this.getQuorumSets(), other.getQuorumSets());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersistedSCPStateV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getScpEnvelopes());
        result = result * 59 + Arrays.deepHashCode(this.getQuorumSets());
        return result;
    }

    @Generated
    public String toString() {
        return "PersistedSCPStateV1(scpEnvelopes=" + Arrays.deepToString(this.getScpEnvelopes()) + ", quorumSets=" + Arrays.deepToString(this.getQuorumSets()) + ")";
    }

    @Generated
    public PersistedSCPStateV1() {
    }

    @Generated
    public PersistedSCPStateV1(SCPEnvelope[] scpEnvelopes, SCPQuorumSet[] quorumSets) {
        this.scpEnvelopes = scpEnvelopes;
        this.quorumSets = quorumSets;
    }

    @Generated
    public static class PersistedSCPStateV1Builder {
        @Generated
        private SCPEnvelope[] scpEnvelopes;
        @Generated
        private SCPQuorumSet[] quorumSets;

        @Generated
        PersistedSCPStateV1Builder() {
        }

        @Generated
        public PersistedSCPStateV1Builder scpEnvelopes(SCPEnvelope[] scpEnvelopes) {
            this.scpEnvelopes = scpEnvelopes;
            return this;
        }

        @Generated
        public PersistedSCPStateV1Builder quorumSets(SCPQuorumSet[] quorumSets) {
            this.quorumSets = quorumSets;
            return this;
        }

        @Generated
        public PersistedSCPStateV1 build() {
            return new PersistedSCPStateV1(this.scpEnvelopes, this.quorumSets);
        }

        @Generated
        public String toString() {
            return "PersistedSCPStateV1.PersistedSCPStateV1Builder(scpEnvelopes=" + Arrays.deepToString(this.scpEnvelopes) + ", quorumSets=" + Arrays.deepToString(this.quorumSets) + ")";
        }
    }
}

