/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.TimeSlicedSurveyRequestMessage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SignedTimeSlicedSurveyRequestMessage
implements XdrElement {
    private Signature requestSignature;
    private TimeSlicedSurveyRequestMessage request;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.requestSignature.encode(stream);
        this.request.encode(stream);
    }

    public static SignedTimeSlicedSurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        SignedTimeSlicedSurveyRequestMessage decodedSignedTimeSlicedSurveyRequestMessage = new SignedTimeSlicedSurveyRequestMessage();
        decodedSignedTimeSlicedSurveyRequestMessage.requestSignature = Signature.decode(stream);
        decodedSignedTimeSlicedSurveyRequestMessage.request = TimeSlicedSurveyRequestMessage.decode(stream);
        return decodedSignedTimeSlicedSurveyRequestMessage;
    }

    public static SignedTimeSlicedSurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignedTimeSlicedSurveyRequestMessage.fromXdrByteArray(bytes);
    }

    public static SignedTimeSlicedSurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignedTimeSlicedSurveyRequestMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static SignedTimeSlicedSurveyRequestMessageBuilder builder() {
        return new SignedTimeSlicedSurveyRequestMessageBuilder();
    }

    @Generated
    public SignedTimeSlicedSurveyRequestMessageBuilder toBuilder() {
        return new SignedTimeSlicedSurveyRequestMessageBuilder().requestSignature(this.requestSignature).request(this.request);
    }

    @Generated
    public Signature getRequestSignature() {
        return this.requestSignature;
    }

    @Generated
    public TimeSlicedSurveyRequestMessage getRequest() {
        return this.request;
    }

    @Generated
    public void setRequestSignature(Signature requestSignature) {
        this.requestSignature = requestSignature;
    }

    @Generated
    public void setRequest(TimeSlicedSurveyRequestMessage request) {
        this.request = request;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedTimeSlicedSurveyRequestMessage)) {
            return false;
        }
        SignedTimeSlicedSurveyRequestMessage other = (SignedTimeSlicedSurveyRequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Signature this$requestSignature = this.getRequestSignature();
        Signature other$requestSignature = other.getRequestSignature();
        if (this$requestSignature == null ? other$requestSignature != null : !((Object)this$requestSignature).equals(other$requestSignature)) {
            return false;
        }
        TimeSlicedSurveyRequestMessage this$request = this.getRequest();
        TimeSlicedSurveyRequestMessage other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignedTimeSlicedSurveyRequestMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Signature $requestSignature = this.getRequestSignature();
        result = result * 59 + ($requestSignature == null ? 43 : ((Object)$requestSignature).hashCode());
        TimeSlicedSurveyRequestMessage $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignedTimeSlicedSurveyRequestMessage(requestSignature=" + this.getRequestSignature() + ", request=" + this.getRequest() + ")";
    }

    @Generated
    public SignedTimeSlicedSurveyRequestMessage() {
    }

    @Generated
    public SignedTimeSlicedSurveyRequestMessage(Signature requestSignature, TimeSlicedSurveyRequestMessage request) {
        this.requestSignature = requestSignature;
        this.request = request;
    }

    @Generated
    public static class SignedTimeSlicedSurveyRequestMessageBuilder {
        @Generated
        private Signature requestSignature;
        @Generated
        private TimeSlicedSurveyRequestMessage request;

        @Generated
        SignedTimeSlicedSurveyRequestMessageBuilder() {
        }

        @Generated
        public SignedTimeSlicedSurveyRequestMessageBuilder requestSignature(Signature requestSignature) {
            this.requestSignature = requestSignature;
            return this;
        }

        @Generated
        public SignedTimeSlicedSurveyRequestMessageBuilder request(TimeSlicedSurveyRequestMessage request) {
            this.request = request;
            return this;
        }

        @Generated
        public SignedTimeSlicedSurveyRequestMessage build() {
            return new SignedTimeSlicedSurveyRequestMessage(this.requestSignature, this.request);
        }

        @Generated
        public String toString() {
            return "SignedTimeSlicedSurveyRequestMessage.SignedTimeSlicedSurveyRequestMessageBuilder(requestSignature=" + this.requestSignature + ", request=" + this.request + ")";
        }
    }
}

