/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.EncryptedBody;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SurveyResponseMessage
implements XdrElement {
    private NodeID surveyorPeerID;
    private NodeID surveyedPeerID;
    private Uint32 ledgerNum;
    private SurveyMessageCommandType commandType;
    private EncryptedBody encryptedBody;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.surveyorPeerID.encode(stream);
        this.surveyedPeerID.encode(stream);
        this.ledgerNum.encode(stream);
        this.commandType.encode(stream);
        this.encryptedBody.encode(stream);
    }

    public static SurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
        SurveyResponseMessage decodedSurveyResponseMessage = new SurveyResponseMessage();
        decodedSurveyResponseMessage.surveyorPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.surveyedPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.ledgerNum = Uint32.decode(stream);
        decodedSurveyResponseMessage.commandType = SurveyMessageCommandType.decode(stream);
        decodedSurveyResponseMessage.encryptedBody = EncryptedBody.decode(stream);
        return decodedSurveyResponseMessage;
    }

    public static SurveyResponseMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SurveyResponseMessage.fromXdrByteArray(bytes);
    }

    public static SurveyResponseMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SurveyResponseMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static SurveyResponseMessageBuilder builder() {
        return new SurveyResponseMessageBuilder();
    }

    @Generated
    public SurveyResponseMessageBuilder toBuilder() {
        return new SurveyResponseMessageBuilder().surveyorPeerID(this.surveyorPeerID).surveyedPeerID(this.surveyedPeerID).ledgerNum(this.ledgerNum).commandType(this.commandType).encryptedBody(this.encryptedBody);
    }

    @Generated
    public NodeID getSurveyorPeerID() {
        return this.surveyorPeerID;
    }

    @Generated
    public NodeID getSurveyedPeerID() {
        return this.surveyedPeerID;
    }

    @Generated
    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    @Generated
    public SurveyMessageCommandType getCommandType() {
        return this.commandType;
    }

    @Generated
    public EncryptedBody getEncryptedBody() {
        return this.encryptedBody;
    }

    @Generated
    public void setSurveyorPeerID(NodeID surveyorPeerID) {
        this.surveyorPeerID = surveyorPeerID;
    }

    @Generated
    public void setSurveyedPeerID(NodeID surveyedPeerID) {
        this.surveyedPeerID = surveyedPeerID;
    }

    @Generated
    public void setLedgerNum(Uint32 ledgerNum) {
        this.ledgerNum = ledgerNum;
    }

    @Generated
    public void setCommandType(SurveyMessageCommandType commandType) {
        this.commandType = commandType;
    }

    @Generated
    public void setEncryptedBody(EncryptedBody encryptedBody) {
        this.encryptedBody = encryptedBody;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SurveyResponseMessage)) {
            return false;
        }
        SurveyResponseMessage other = (SurveyResponseMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$surveyorPeerID = this.getSurveyorPeerID();
        NodeID other$surveyorPeerID = other.getSurveyorPeerID();
        if (this$surveyorPeerID == null ? other$surveyorPeerID != null : !((Object)this$surveyorPeerID).equals(other$surveyorPeerID)) {
            return false;
        }
        NodeID this$surveyedPeerID = this.getSurveyedPeerID();
        NodeID other$surveyedPeerID = other.getSurveyedPeerID();
        if (this$surveyedPeerID == null ? other$surveyedPeerID != null : !((Object)this$surveyedPeerID).equals(other$surveyedPeerID)) {
            return false;
        }
        Uint32 this$ledgerNum = this.getLedgerNum();
        Uint32 other$ledgerNum = other.getLedgerNum();
        if (this$ledgerNum == null ? other$ledgerNum != null : !((Object)this$ledgerNum).equals(other$ledgerNum)) {
            return false;
        }
        SurveyMessageCommandType this$commandType = this.getCommandType();
        SurveyMessageCommandType other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        EncryptedBody this$encryptedBody = this.getEncryptedBody();
        EncryptedBody other$encryptedBody = other.getEncryptedBody();
        return !(this$encryptedBody == null ? other$encryptedBody != null : !((Object)this$encryptedBody).equals(other$encryptedBody));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SurveyResponseMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $surveyorPeerID = this.getSurveyorPeerID();
        result = result * 59 + ($surveyorPeerID == null ? 43 : ((Object)$surveyorPeerID).hashCode());
        NodeID $surveyedPeerID = this.getSurveyedPeerID();
        result = result * 59 + ($surveyedPeerID == null ? 43 : ((Object)$surveyedPeerID).hashCode());
        Uint32 $ledgerNum = this.getLedgerNum();
        result = result * 59 + ($ledgerNum == null ? 43 : ((Object)$ledgerNum).hashCode());
        SurveyMessageCommandType $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        EncryptedBody $encryptedBody = this.getEncryptedBody();
        result = result * 59 + ($encryptedBody == null ? 43 : ((Object)$encryptedBody).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SurveyResponseMessage(surveyorPeerID=" + this.getSurveyorPeerID() + ", surveyedPeerID=" + this.getSurveyedPeerID() + ", ledgerNum=" + this.getLedgerNum() + ", commandType=" + this.getCommandType() + ", encryptedBody=" + this.getEncryptedBody() + ")";
    }

    @Generated
    public SurveyResponseMessage() {
    }

    @Generated
    public SurveyResponseMessage(NodeID surveyorPeerID, NodeID surveyedPeerID, Uint32 ledgerNum, SurveyMessageCommandType commandType, EncryptedBody encryptedBody) {
        this.surveyorPeerID = surveyorPeerID;
        this.surveyedPeerID = surveyedPeerID;
        this.ledgerNum = ledgerNum;
        this.commandType = commandType;
        this.encryptedBody = encryptedBody;
    }

    @Generated
    public static class SurveyResponseMessageBuilder {
        @Generated
        private NodeID surveyorPeerID;
        @Generated
        private NodeID surveyedPeerID;
        @Generated
        private Uint32 ledgerNum;
        @Generated
        private SurveyMessageCommandType commandType;
        @Generated
        private EncryptedBody encryptedBody;

        @Generated
        SurveyResponseMessageBuilder() {
        }

        @Generated
        public SurveyResponseMessageBuilder surveyorPeerID(NodeID surveyorPeerID) {
            this.surveyorPeerID = surveyorPeerID;
            return this;
        }

        @Generated
        public SurveyResponseMessageBuilder surveyedPeerID(NodeID surveyedPeerID) {
            this.surveyedPeerID = surveyedPeerID;
            return this;
        }

        @Generated
        public SurveyResponseMessageBuilder ledgerNum(Uint32 ledgerNum) {
            this.ledgerNum = ledgerNum;
            return this;
        }

        @Generated
        public SurveyResponseMessageBuilder commandType(SurveyMessageCommandType commandType) {
            this.commandType = commandType;
            return this;
        }

        @Generated
        public SurveyResponseMessageBuilder encryptedBody(EncryptedBody encryptedBody) {
            this.encryptedBody = encryptedBody;
            return this;
        }

        @Generated
        public SurveyResponseMessage build() {
            return new SurveyResponseMessage(this.surveyorPeerID, this.surveyedPeerID, this.ledgerNum, this.commandType, this.encryptedBody);
        }

        @Generated
        public String toString() {
            return "SurveyResponseMessage.SurveyResponseMessageBuilder(surveyorPeerID=" + this.surveyorPeerID + ", surveyedPeerID=" + this.surveyedPeerID + ", ledgerNum=" + this.ledgerNum + ", commandType=" + this.commandType + ", encryptedBody=" + this.encryptedBody + ")";
        }
    }
}

