/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.SorobanTransactionData;

public class TransactionBuilder {
    private final TransactionBuilderAccount sourceAccount;
    private Memo memo;
    private final List<Operation> operations;
    private Long baseFee;
    private final Network network;
    @NonNull
    private TransactionPreconditions preconditions;
    private SorobanTransactionData sorobanData;
    private BigInteger txTimeout;

    public TransactionBuilder(@NonNull TransactionBuilderAccount sourceAccount, @NonNull Network network) {
        if (sourceAccount == null) {
            throw new NullPointerException("sourceAccount is marked non-null but is null");
        }
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        this.sourceAccount = sourceAccount;
        this.network = network;
        this.operations = new ArrayList<Operation>();
        this.preconditions = TransactionPreconditions.builder().build();
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    public TransactionBuilder addOperation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operations.add(operation);
        return this;
    }

    public TransactionBuilder addOperations(@NonNull Collection<Operation> operations) {
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.operations.addAll(operations);
        return this;
    }

    public TransactionBuilder addPreconditions(@NonNull TransactionPreconditions preconditions) {
        if (preconditions == null) {
            throw new NullPointerException("preconditions is marked non-null but is null");
        }
        this.preconditions = preconditions;
        return this;
    }

    public TransactionBuilder addMemo(@NonNull Memo memo) {
        if (memo == null) {
            throw new NullPointerException("memo is marked non-null but is null");
        }
        if (this.memo != null) {
            throw new IllegalStateException("Memo has been already added.");
        }
        this.memo = memo;
        return this;
    }

    public TransactionBuilder setTimeout(BigInteger timeout) {
        if (timeout.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.txTimeout = timeout;
        return this;
    }

    public TransactionBuilder setTimeout(long timeout) {
        return this.setTimeout(BigInteger.valueOf(timeout));
    }

    public TransactionBuilder setBaseFee(long baseFee) {
        if (baseFee < 100L) {
            throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
        }
        this.baseFee = baseFee;
        return this;
    }

    public Transaction build() {
        if (this.preconditions.getTimeBounds() != null && this.txTimeout != null) {
            throw new IllegalStateException("Can not set both TransactionPreconditions.timeBounds and timeout.");
        }
        if (this.txTimeout != null) {
            BigInteger maxTime = !TransactionPreconditions.TIMEOUT_INFINITE.equals(this.txTimeout) ? this.txTimeout.add(BigInteger.valueOf(System.currentTimeMillis() / 1000L)) : TransactionPreconditions.TIMEOUT_INFINITE;
            this.preconditions = this.preconditions.toBuilder().timeBounds(new TimeBounds(BigInteger.ZERO, maxTime)).build();
        }
        this.preconditions.validate();
        if (this.baseFee == null) {
            throw new IllegalStateException("baseFee has to be set. you must call setBaseFee().");
        }
        if (this.network == null) {
            throw new IllegalStateException("network has to be set. you must call setNetwork().");
        }
        long sequenceNumber = this.sourceAccount.getIncrementedSequenceNumber();
        Operation[] operations = new Operation[this.operations.size()];
        operations = this.operations.toArray(operations);
        long fee = (long)operations.length * this.baseFee;
        if (this.sorobanData != null) {
            fee += this.sorobanData.getResourceFee().getInt64().longValue();
        }
        Transaction transaction = new Transaction(this.sourceAccount.getAccountId(), fee, sequenceNumber, operations, this.memo, this.preconditions, this.sorobanData, this.network);
        this.sourceAccount.setSequenceNumber(sequenceNumber);
        return transaction;
    }

    public TransactionBuilder setSorobanData(SorobanTransactionData sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }

    public TransactionBuilder setSorobanData(String sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }
}

