/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;

public class RevokeDataSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final String dataName;

    public static RevokeDataSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        String accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getData().getAccountID());
        String dataName = op.getLedgerKey().getData().getDataName().getString64().toString();
        return new RevokeDataSponsorshipOperation(accountId, dataName);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.DATA);
        LedgerKey.LedgerKeyData data = new LedgerKey.LedgerKeyData();
        data.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        String64 dn = new String64();
        dn.setString64(new XdrString(this.dataName));
        data.setDataName(dn);
        key.setData(data);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeDataSponsorshipOperation(RevokeDataSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.accountId = ((RevokeDataSponsorshipOperationBuilder)b).accountId;
        if (this.accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.dataName = ((RevokeDataSponsorshipOperationBuilder)b).dataName;
        if (this.dataName == null) {
            throw new NullPointerException("dataName is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeDataSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeDataSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeDataSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeDataSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public String getDataName() {
        return this.dataName;
    }

    @Generated
    public String toString() {
        return "RevokeDataSponsorshipOperation(super=" + super.toString() + ", accountId=" + this.getAccountId() + ", dataName=" + this.getDataName() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeDataSponsorshipOperation)) {
            return false;
        }
        RevokeDataSponsorshipOperation other = (RevokeDataSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$dataName = this.getDataName();
        String other$dataName = other.getDataName();
        return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeDataSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $dataName = this.getDataName();
        result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
        return result;
    }

    @Generated
    private RevokeDataSponsorshipOperation(@NonNull String accountId, @NonNull String dataName) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (dataName == null) {
            throw new NullPointerException("dataName is marked non-null but is null");
        }
        this.accountId = accountId;
        this.dataName = dataName;
    }

    @Generated
    public static abstract class RevokeDataSponsorshipOperationBuilder<C extends RevokeDataSponsorshipOperation, B extends RevokeDataSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String accountId;
        @Generated
        private String dataName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeDataSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeDataSponsorshipOperation instance, RevokeDataSponsorshipOperationBuilder<?, ?> b) {
            b.accountId(instance.accountId);
            b.dataName(instance.dataName);
        }

        @Generated
        public B accountId(@NonNull String accountId) {
            if (accountId == null) {
                throw new NullPointerException("accountId is marked non-null but is null");
            }
            this.accountId = accountId;
            return (B)this.self();
        }

        @Generated
        public B dataName(@NonNull String dataName) {
            if (dataName == null) {
                throw new NullPointerException("dataName is marked non-null but is null");
            }
            this.dataName = dataName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeDataSponsorshipOperation.RevokeDataSponsorshipOperationBuilder(super=" + super.toString() + ", accountId=" + this.accountId + ", dataName=" + this.dataName + ")";
        }
    }

    @Generated
    private static final class RevokeDataSponsorshipOperationBuilderImpl
    extends RevokeDataSponsorshipOperationBuilder<RevokeDataSponsorshipOperation, RevokeDataSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeDataSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeDataSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeDataSponsorshipOperation build() {
            return new RevokeDataSponsorshipOperation(this);
        }
    }
}

