/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ArchivalProofNode
implements XdrElement {
    private Uint32 index;
    private Hash hash;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.index.encode(stream);
        this.hash.encode(stream);
    }

    public static ArchivalProofNode decode(XdrDataInputStream stream) throws IOException {
        ArchivalProofNode decodedArchivalProofNode = new ArchivalProofNode();
        decodedArchivalProofNode.index = Uint32.decode(stream);
        decodedArchivalProofNode.hash = Hash.decode(stream);
        return decodedArchivalProofNode;
    }

    public static ArchivalProofNode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ArchivalProofNode.fromXdrByteArray(bytes);
    }

    public static ArchivalProofNode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ArchivalProofNode.decode(xdrDataInputStream);
    }

    @Generated
    public static ArchivalProofNodeBuilder builder() {
        return new ArchivalProofNodeBuilder();
    }

    @Generated
    public ArchivalProofNodeBuilder toBuilder() {
        return new ArchivalProofNodeBuilder().index(this.index).hash(this.hash);
    }

    @Generated
    public Uint32 getIndex() {
        return this.index;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public void setIndex(Uint32 index) {
        this.index = index;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivalProofNode)) {
            return false;
        }
        ArchivalProofNode other = (ArchivalProofNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$index = this.getIndex();
        Uint32 other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivalProofNode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArchivalProofNode(index=" + this.getIndex() + ", hash=" + this.getHash() + ")";
    }

    @Generated
    public ArchivalProofNode() {
    }

    @Generated
    public ArchivalProofNode(Uint32 index, Hash hash) {
        this.index = index;
        this.hash = hash;
    }

    @Generated
    public static class ArchivalProofNodeBuilder {
        @Generated
        private Uint32 index;
        @Generated
        private Hash hash;

        @Generated
        ArchivalProofNodeBuilder() {
        }

        @Generated
        public ArchivalProofNodeBuilder index(Uint32 index) {
            this.index = index;
            return this;
        }

        @Generated
        public ArchivalProofNodeBuilder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        @Generated
        public ArchivalProofNode build() {
            return new ArchivalProofNode(this.index, this.hash);
        }

        @Generated
        public String toString() {
            return "ArchivalProofNode.ArchivalProofNodeBuilder(index=" + this.index + ", hash=" + this.hash + ")";
        }
    }
}

