/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractDataEntry
implements XdrElement {
    private ExtensionPoint ext;
    private SCAddress contract;
    private SCVal key;
    private ContractDataDurability durability;
    private SCVal val;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.contract.encode(stream);
        this.key.encode(stream);
        this.durability.encode(stream);
        this.val.encode(stream);
    }

    public static ContractDataEntry decode(XdrDataInputStream stream) throws IOException {
        ContractDataEntry decodedContractDataEntry = new ContractDataEntry();
        decodedContractDataEntry.ext = ExtensionPoint.decode(stream);
        decodedContractDataEntry.contract = SCAddress.decode(stream);
        decodedContractDataEntry.key = SCVal.decode(stream);
        decodedContractDataEntry.durability = ContractDataDurability.decode(stream);
        decodedContractDataEntry.val = SCVal.decode(stream);
        return decodedContractDataEntry;
    }

    public static ContractDataEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractDataEntry.fromXdrByteArray(bytes);
    }

    public static ContractDataEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractDataEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static ContractDataEntryBuilder builder() {
        return new ContractDataEntryBuilder();
    }

    @Generated
    public ContractDataEntryBuilder toBuilder() {
        return new ContractDataEntryBuilder().ext(this.ext).contract(this.contract).key(this.key).durability(this.durability).val(this.val);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public SCAddress getContract() {
        return this.contract;
    }

    @Generated
    public SCVal getKey() {
        return this.key;
    }

    @Generated
    public ContractDataDurability getDurability() {
        return this.durability;
    }

    @Generated
    public SCVal getVal() {
        return this.val;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setContract(SCAddress contract) {
        this.contract = contract;
    }

    @Generated
    public void setKey(SCVal key) {
        this.key = key;
    }

    @Generated
    public void setDurability(ContractDataDurability durability) {
        this.durability = durability;
    }

    @Generated
    public void setVal(SCVal val) {
        this.val = val;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractDataEntry)) {
            return false;
        }
        ContractDataEntry other = (ContractDataEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        SCAddress this$contract = this.getContract();
        SCAddress other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !((Object)this$contract).equals(other$contract)) {
            return false;
        }
        SCVal this$key = this.getKey();
        SCVal other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        ContractDataDurability this$durability = this.getDurability();
        ContractDataDurability other$durability = other.getDurability();
        if (this$durability == null ? other$durability != null : !this$durability.equals(other$durability)) {
            return false;
        }
        SCVal this$val = this.getVal();
        SCVal other$val = other.getVal();
        return !(this$val == null ? other$val != null : !((Object)this$val).equals(other$val));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContractDataEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        SCAddress $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : ((Object)$contract).hashCode());
        SCVal $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        ContractDataDurability $durability = this.getDurability();
        result = result * 59 + ($durability == null ? 43 : $durability.hashCode());
        SCVal $val = this.getVal();
        result = result * 59 + ($val == null ? 43 : ((Object)$val).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractDataEntry(ext=" + this.getExt() + ", contract=" + this.getContract() + ", key=" + this.getKey() + ", durability=" + this.getDurability() + ", val=" + this.getVal() + ")";
    }

    @Generated
    public ContractDataEntry() {
    }

    @Generated
    public ContractDataEntry(ExtensionPoint ext, SCAddress contract, SCVal key, ContractDataDurability durability, SCVal val) {
        this.ext = ext;
        this.contract = contract;
        this.key = key;
        this.durability = durability;
        this.val = val;
    }

    @Generated
    public static class ContractDataEntryBuilder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private SCAddress contract;
        @Generated
        private SCVal key;
        @Generated
        private ContractDataDurability durability;
        @Generated
        private SCVal val;

        @Generated
        ContractDataEntryBuilder() {
        }

        @Generated
        public ContractDataEntryBuilder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public ContractDataEntryBuilder contract(SCAddress contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public ContractDataEntryBuilder key(SCVal key) {
            this.key = key;
            return this;
        }

        @Generated
        public ContractDataEntryBuilder durability(ContractDataDurability durability) {
            this.durability = durability;
            return this;
        }

        @Generated
        public ContractDataEntryBuilder val(SCVal val) {
            this.val = val;
            return this;
        }

        @Generated
        public ContractDataEntry build() {
            return new ContractDataEntry(this.ext, this.contract, this.key, this.durability, this.val);
        }

        @Generated
        public String toString() {
            return "ContractDataEntry.ContractDataEntryBuilder(ext=" + this.ext + ", contract=" + this.contract + ", key=" + this.key + ", durability=" + this.durability + ", val=" + this.val + ")";
        }
    }
}

