/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SorobanAuthorizedFunction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAuthorizedInvocation
implements XdrElement {
    private SorobanAuthorizedFunction function;
    private SorobanAuthorizedInvocation[] subInvocations;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.function.encode(stream);
        int subInvocationsSize = this.getSubInvocations().length;
        stream.writeInt(subInvocationsSize);
        for (int i = 0; i < subInvocationsSize; ++i) {
            this.subInvocations[i].encode(stream);
        }
    }

    public static SorobanAuthorizedInvocation decode(XdrDataInputStream stream) throws IOException {
        SorobanAuthorizedInvocation decodedSorobanAuthorizedInvocation = new SorobanAuthorizedInvocation();
        decodedSorobanAuthorizedInvocation.function = SorobanAuthorizedFunction.decode(stream);
        int subInvocationsSize = stream.readInt();
        decodedSorobanAuthorizedInvocation.subInvocations = new SorobanAuthorizedInvocation[subInvocationsSize];
        for (int i = 0; i < subInvocationsSize; ++i) {
            decodedSorobanAuthorizedInvocation.subInvocations[i] = SorobanAuthorizedInvocation.decode(stream);
        }
        return decodedSorobanAuthorizedInvocation;
    }

    public static SorobanAuthorizedInvocation fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAuthorizedInvocation.fromXdrByteArray(bytes);
    }

    public static SorobanAuthorizedInvocation fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAuthorizedInvocation.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanAuthorizedInvocationBuilder builder() {
        return new SorobanAuthorizedInvocationBuilder();
    }

    @Generated
    public SorobanAuthorizedInvocationBuilder toBuilder() {
        return new SorobanAuthorizedInvocationBuilder().function(this.function).subInvocations(this.subInvocations);
    }

    @Generated
    public SorobanAuthorizedFunction getFunction() {
        return this.function;
    }

    @Generated
    public SorobanAuthorizedInvocation[] getSubInvocations() {
        return this.subInvocations;
    }

    @Generated
    public void setFunction(SorobanAuthorizedFunction function) {
        this.function = function;
    }

    @Generated
    public void setSubInvocations(SorobanAuthorizedInvocation[] subInvocations) {
        this.subInvocations = subInvocations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanAuthorizedInvocation)) {
            return false;
        }
        SorobanAuthorizedInvocation other = (SorobanAuthorizedInvocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorobanAuthorizedFunction this$function = this.getFunction();
        SorobanAuthorizedFunction other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubInvocations(), other.getSubInvocations());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanAuthorizedInvocation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorobanAuthorizedFunction $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubInvocations());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanAuthorizedInvocation(function=" + this.getFunction() + ", subInvocations=" + Arrays.deepToString(this.getSubInvocations()) + ")";
    }

    @Generated
    public SorobanAuthorizedInvocation() {
    }

    @Generated
    public SorobanAuthorizedInvocation(SorobanAuthorizedFunction function, SorobanAuthorizedInvocation[] subInvocations) {
        this.function = function;
        this.subInvocations = subInvocations;
    }

    @Generated
    public static class SorobanAuthorizedInvocationBuilder {
        @Generated
        private SorobanAuthorizedFunction function;
        @Generated
        private SorobanAuthorizedInvocation[] subInvocations;

        @Generated
        SorobanAuthorizedInvocationBuilder() {
        }

        @Generated
        public SorobanAuthorizedInvocationBuilder function(SorobanAuthorizedFunction function) {
            this.function = function;
            return this;
        }

        @Generated
        public SorobanAuthorizedInvocationBuilder subInvocations(SorobanAuthorizedInvocation[] subInvocations) {
            this.subInvocations = subInvocations;
            return this;
        }

        @Generated
        public SorobanAuthorizedInvocation build() {
            return new SorobanAuthorizedInvocation(this.function, this.subInvocations);
        }

        @Generated
        public String toString() {
            return "SorobanAuthorizedInvocation.SorobanAuthorizedInvocationBuilder(function=" + this.function + ", subInvocations=" + Arrays.deepToString(this.subInvocations) + ")";
        }
    }
}

