/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Memo;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.Preconditions;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Transaction
implements XdrElement {
    private MuxedAccount sourceAccount;
    private Uint32 fee;
    private SequenceNumber seqNum;
    private Preconditions cond;
    private Memo memo;
    private Operation[] operations;
    private TransactionExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sourceAccount.encode(stream);
        this.fee.encode(stream);
        this.seqNum.encode(stream);
        this.cond.encode(stream);
        this.memo.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static Transaction decode(XdrDataInputStream stream) throws IOException {
        Transaction decodedTransaction = new Transaction();
        decodedTransaction.sourceAccount = MuxedAccount.decode(stream);
        decodedTransaction.fee = Uint32.decode(stream);
        decodedTransaction.seqNum = SequenceNumber.decode(stream);
        decodedTransaction.cond = Preconditions.decode(stream);
        decodedTransaction.memo = Memo.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransaction.operations = new Operation[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransaction.operations[i] = Operation.decode(stream);
        }
        decodedTransaction.ext = TransactionExt.decode(stream);
        return decodedTransaction;
    }

    public static Transaction fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Transaction.fromXdrByteArray(bytes);
    }

    public static Transaction fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Transaction.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    @Generated
    public TransactionBuilder toBuilder() {
        return new TransactionBuilder().sourceAccount(this.sourceAccount).fee(this.fee).seqNum(this.seqNum).cond(this.cond).memo(this.memo).operations(this.operations).ext(this.ext);
    }

    @Generated
    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public Uint32 getFee() {
        return this.fee;
    }

    @Generated
    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    @Generated
    public Preconditions getCond() {
        return this.cond;
    }

    @Generated
    public Memo getMemo() {
        return this.memo;
    }

    @Generated
    public Operation[] getOperations() {
        return this.operations;
    }

    @Generated
    public TransactionExt getExt() {
        return this.ext;
    }

    @Generated
    public void setSourceAccount(MuxedAccount sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    @Generated
    public void setFee(Uint32 fee) {
        this.fee = fee;
    }

    @Generated
    public void setSeqNum(SequenceNumber seqNum) {
        this.seqNum = seqNum;
    }

    @Generated
    public void setCond(Preconditions cond) {
        this.cond = cond;
    }

    @Generated
    public void setMemo(Memo memo) {
        this.memo = memo;
    }

    @Generated
    public void setOperations(Operation[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setExt(TransactionExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MuxedAccount this$sourceAccount = this.getSourceAccount();
        MuxedAccount other$sourceAccount = other.getSourceAccount();
        if (this$sourceAccount == null ? other$sourceAccount != null : !((Object)this$sourceAccount).equals(other$sourceAccount)) {
            return false;
        }
        Uint32 this$fee = this.getFee();
        Uint32 other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        SequenceNumber this$seqNum = this.getSeqNum();
        SequenceNumber other$seqNum = other.getSeqNum();
        if (this$seqNum == null ? other$seqNum != null : !((Object)this$seqNum).equals(other$seqNum)) {
            return false;
        }
        Preconditions this$cond = this.getCond();
        Preconditions other$cond = other.getCond();
        if (this$cond == null ? other$cond != null : !((Object)this$cond).equals(other$cond)) {
            return false;
        }
        Memo this$memo = this.getMemo();
        Memo other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !((Object)this$memo).equals(other$memo)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        TransactionExt this$ext = this.getExt();
        TransactionExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MuxedAccount $sourceAccount = this.getSourceAccount();
        result = result * 59 + ($sourceAccount == null ? 43 : ((Object)$sourceAccount).hashCode());
        Uint32 $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        SequenceNumber $seqNum = this.getSeqNum();
        result = result * 59 + ($seqNum == null ? 43 : ((Object)$seqNum).hashCode());
        Preconditions $cond = this.getCond();
        result = result * 59 + ($cond == null ? 43 : ((Object)$cond).hashCode());
        Memo $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : ((Object)$memo).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        TransactionExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transaction(sourceAccount=" + this.getSourceAccount() + ", fee=" + this.getFee() + ", seqNum=" + this.getSeqNum() + ", cond=" + this.getCond() + ", memo=" + this.getMemo() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public Transaction() {
    }

    @Generated
    public Transaction(MuxedAccount sourceAccount, Uint32 fee, SequenceNumber seqNum, Preconditions cond, Memo memo, Operation[] operations, TransactionExt ext) {
        this.sourceAccount = sourceAccount;
        this.fee = fee;
        this.seqNum = seqNum;
        this.cond = cond;
        this.memo = memo;
        this.operations = operations;
        this.ext = ext;
    }

    public static class TransactionExt
    implements XdrElement {
        private Integer discriminant;
        private SorobanTransactionData sorobanData;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sorobanData.encode(stream);
                }
            }
        }

        public static TransactionExt decode(XdrDataInputStream stream) throws IOException {
            TransactionExt decodedTransactionExt = new TransactionExt();
            Integer discriminant = stream.readInt();
            decodedTransactionExt.setDiscriminant(discriminant);
            switch (decodedTransactionExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTransactionExt.sorobanData = SorobanTransactionData.decode(stream);
                }
            }
            return decodedTransactionExt;
        }

        public static TransactionExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionExt.fromXdrByteArray(bytes);
        }

        public static TransactionExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionExt.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionExtBuilder builder() {
            return new TransactionExtBuilder();
        }

        @Generated
        public TransactionExtBuilder toBuilder() {
            return new TransactionExtBuilder().discriminant(this.discriminant).sorobanData(this.sorobanData);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public SorobanTransactionData getSorobanData() {
            return this.sorobanData;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setSorobanData(SorobanTransactionData sorobanData) {
            this.sorobanData = sorobanData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionExt)) {
                return false;
            }
            TransactionExt other = (TransactionExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            SorobanTransactionData this$sorobanData = this.getSorobanData();
            SorobanTransactionData other$sorobanData = other.getSorobanData();
            return !(this$sorobanData == null ? other$sorobanData != null : !((Object)this$sorobanData).equals(other$sorobanData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            SorobanTransactionData $sorobanData = this.getSorobanData();
            result = result * 59 + ($sorobanData == null ? 43 : ((Object)$sorobanData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Transaction.TransactionExt(discriminant=" + this.getDiscriminant() + ", sorobanData=" + this.getSorobanData() + ")";
        }

        @Generated
        public TransactionExt() {
        }

        @Generated
        public TransactionExt(Integer discriminant, SorobanTransactionData sorobanData) {
            this.discriminant = discriminant;
            this.sorobanData = sorobanData;
        }

        @Generated
        public static class TransactionExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private SorobanTransactionData sorobanData;

            @Generated
            TransactionExtBuilder() {
            }

            @Generated
            public TransactionExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionExtBuilder sorobanData(SorobanTransactionData sorobanData) {
                this.sorobanData = sorobanData;
                return this;
            }

            @Generated
            public TransactionExt build() {
                return new TransactionExt(this.discriminant, this.sorobanData);
            }

            @Generated
            public String toString() {
                return "Transaction.TransactionExt.TransactionExtBuilder(discriminant=" + this.discriminant + ", sorobanData=" + this.sorobanData + ")";
            }
        }
    }

    @Generated
    public static class TransactionBuilder {
        @Generated
        private MuxedAccount sourceAccount;
        @Generated
        private Uint32 fee;
        @Generated
        private SequenceNumber seqNum;
        @Generated
        private Preconditions cond;
        @Generated
        private Memo memo;
        @Generated
        private Operation[] operations;
        @Generated
        private TransactionExt ext;

        @Generated
        TransactionBuilder() {
        }

        @Generated
        public TransactionBuilder sourceAccount(MuxedAccount sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        @Generated
        public TransactionBuilder fee(Uint32 fee) {
            this.fee = fee;
            return this;
        }

        @Generated
        public TransactionBuilder seqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
            return this;
        }

        @Generated
        public TransactionBuilder cond(Preconditions cond) {
            this.cond = cond;
            return this;
        }

        @Generated
        public TransactionBuilder memo(Memo memo) {
            this.memo = memo;
            return this;
        }

        @Generated
        public TransactionBuilder operations(Operation[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionBuilder ext(TransactionExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public Transaction build() {
            return new Transaction(this.sourceAccount, this.fee, this.seqNum, this.cond, this.memo, this.operations, this.ext);
        }

        @Generated
        public String toString() {
            return "Transaction.TransactionBuilder(sourceAccount=" + this.sourceAccount + ", fee=" + this.fee + ", seqNum=" + this.seqNum + ", cond=" + this.cond + ", memo=" + this.memo + ", operations=" + Arrays.deepToString(this.operations) + ", ext=" + this.ext + ")";
        }
    }
}

